package com.tykj.zydd.user.jwt;

import com.tykj.zydd.misc.exception.ApiException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpStatus;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.filter.GenericFilterBean;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * @author zhoushaopan
 */
@Slf4j
public class JwtTokenAuthenticationFilter extends GenericFilterBean {

    private static final AntPathMatcher PATH_MATCHER = new AntPathMatcher();

    private final JwtTokenProvider jwtTokenProvider;

    public JwtTokenAuthenticationFilter(JwtTokenProvider jwtTokenProvider) {
        this.jwtTokenProvider = jwtTokenProvider;
    }

//    @Override
//    public void doFilter(ServletRequest req, ServletResponse res, FilterChain filterChain)
//            throws IOException, ServletException {
//        HttpServletRequest request = (HttpServletRequest) req;
//        HttpServletResponse response = (HttpServletResponse) res;
//        try {
//            String token = jwtTokenProvider.resolveToken(request);
//            if (token != null){
//                //验证token
//                Boolean aBoolean = jwtTokenProvider.redisValidToken(token);
//                if (aBoolean) {
//                    //说明token存在
//                    jwtTokenProvider.getAuthentication(token);
//                    //同时刷新token
//                    jwtTokenProvider.flashToken(token);
//                }else {
////                    response.setStatus(HttpStatus.FORBIDDEN.value());
////                    response.setContentType("application/json");
////                    response.setCharacterEncoding("utf-8");
////                    response.getWriter().println("{\"code\":403,\"msg\":\"token不合法\"}");
////                    response.getWriter().flush();
////                    response.getWriter().close();
//                    throw new ApiException("token不合法", String.valueOf(HttpStatus.FORBIDDEN.value()));
////                    return;
//                }
//            }
//
//        } catch (InvalidJwtAuthenticationException e) {
////            response.setStatus(HttpStatus.FORBIDDEN.value());
////            response.setContentType("application/json");
////            response.setCharacterEncoding("utf-8");
////            response.getWriter().println("{\"code\":403,\"msg\":\"token不合法\"}");
////            response.getWriter().flush();
////            response.getWriter().close();
//            throw new ApiException("token不合法", String.valueOf(HttpStatus.FORBIDDEN.value()));
//            return;
//        }
//        filterChain.doFilter(request,response);
//    }

    @Override
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain filterChain)
            throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest) req;
        HttpServletResponse response = (HttpServletResponse) res;
        String token = jwtTokenProvider.resolveToken(request);
        if (token != null){
            //验证token
            Boolean aBoolean = jwtTokenProvider.redisValidToken(token);
            if (aBoolean) {
                //说明token存在
                jwtTokenProvider.getAuthentication(token);
                //同时刷新token
                jwtTokenProvider.flashToken(token);
            }else {
                    response.setStatus(HttpStatus.OK.value());
                    response.setContentType("application/json");
                    response.setCharacterEncoding("utf-8");
                    response.getWriter().println("{\"code\":403,\"msg\":\"token不合法\"}");
                    response.getWriter().flush();
                    response.getWriter().close();
                    return;
            }
        }
        filterChain.doFilter(request,response);
    }


    /**
     * 为路径做检验
     * @param urls 需要放行的路径
     * @param requestURI 请求的路径
     * @return true false
     */
    private Boolean check(String[] urls,String requestURI){
        for (String url : urls) {
            boolean match = PATH_MATCHER.match(url, requestURI);
            if (match) {
                return true;
            }
        }
        return false;
    }

}
