package com.tykj.transfer.SlaveService.impl;

import com.alibaba.druid.util.StringUtils;
import com.tykj.transfer.SlaveDao.Biz088DcActivityStatisticsDao;
import com.tykj.transfer.SlaveService.Biz088DcActivityStatisticsService;
import com.tykj.transfer.dao.ActivitiesDao;
import com.tykj.transfer.entity.Activity;
import com.tykj.transfer.entity.Branches;
import com.tykj.transfer.pojo.Biz088DcActivityStatistics;
import com.tykj.transfer.pojo.Biz088DcNetworkStatistics;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;

@Service
@Slf4j
public class Biz088DcActivityStatisticsServiceImpl implements Biz088DcActivityStatisticsService {

    @Resource
    private ActivitiesDao activitiesDao;

    @Resource
    private Biz088DcActivityStatisticsDao biz088DcActivityStatisticsDao;



    @Override
    public void transferActivity() {
        List<Activity> all = activitiesDao.findAll();
        Date date = new Date();
        List<Biz088DcActivityStatistics> rs=new ArrayList<>();
        for (Activity activity : all) {
            // 检查数据库是否已存在的对象
            Optional<Biz088DcActivityStatistics> byId = biz088DcActivityStatisticsDao.findById(activity.getId());
            if (byId.isPresent()) {
                // 如果已存在，进行更新操作
                Biz088DcActivityStatistics biz088DcActivityStatistics = byId.get();
                BeanUtils.copyProperties(activity, biz088DcActivityStatistics);
                biz088DcActivityStatisticsDao.save(biz088DcActivityStatistics);
            } else {
                // 否则，进行保存操作
                Biz088DcActivityStatistics newObj = new Biz088DcActivityStatistics();
                BeanUtils.copyProperties(activity, newObj);
                newObj.setBizTime(date);
                newObj.setLoadTime(date);
                if(!StringUtils.equals(activity.getDataActiveStatus(), "1")) {
                    newObj.setOp("delete");
                }
                newObj.setTongTime(date);
                newObj.setTongId(0L);
                rs.add(newObj);
            }
        }
        if (!rs.isEmpty()) {
            biz088DcActivityStatisticsDao.saveAll(rs);
        }

        log.info("活动转移完成，成功转移了{}条",rs.size());
    }
}
