package com.tykj.transfer.SlaveService.impl;

import com.alibaba.druid.util.StringUtils;
import com.tykj.transfer.SlaveDao.Biz088DcNetworkStatisticsDao;
import com.tykj.transfer.SlaveService.Biz088DcNetworkStatisticsService;
import com.tykj.transfer.dao.BranchesDao;
import com.tykj.transfer.entity.Branches;
import com.tykj.transfer.pojo.Biz088DcNetworkStatistics;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;

@Service
@Slf4j
public class Biz088DcBranchTrainStatisticsImpl implements Biz088DcNetworkStatisticsService {

    @Resource
    private BranchesDao branchesDao;

    @Resource
    private Biz088DcNetworkStatisticsDao biz088DcNetworkStatisticsDao;

    @Override
    public void transferBranch() {
        List<Branches> all = branchesDao.findAll();
        Date date = new Date();
        List<Biz088DcNetworkStatistics> rs=new ArrayList<>();
        for (Branches branches : all) {
            // 检查数据库是否已存在的对象
            Optional<Biz088DcNetworkStatistics> byId = biz088DcNetworkStatisticsDao.findById(branches.getId());
            if (byId.isPresent()) {
                // 如果已存在，进行更新操作
                Biz088DcNetworkStatistics biz088DcBranchTrainStatistics = byId.get();
                BeanUtils.copyProperties(branches, biz088DcBranchTrainStatistics);
                biz088DcNetworkStatisticsDao.save(biz088DcBranchTrainStatistics);
            } else {
                // 否则，进行保存操作
                Biz088DcNetworkStatistics newObj = new Biz088DcNetworkStatistics();
                BeanUtils.copyProperties(branches, newObj);
                newObj.setBizTime(date);
                newObj.setLoadTime(date);
                if(!StringUtils.equals(branches.getDataActiveStatus(), "1")) {
                    newObj.setOp("delete");
                }
                newObj.setTongTime(date);
                newObj.setTongId(0L);
                rs.add(newObj);
            }
        }
        if (!rs.isEmpty()) {
            biz088DcNetworkStatisticsDao.saveAll(rs);
        }
        log.info("网点转移完成,成功转移了{}条",rs.size());
    }

}
