package com.tykj.transfer.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateProperties;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateSettings;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.orm.jpa.EntityManagerFactoryBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

import javax.persistence.EntityManager;
import javax.sql.DataSource;
import java.util.Map;

@SuppressWarnings("ALL")
@Configuration
@EnableTransactionManagement
@EnableJpaRepositories(
        entityManagerFactoryRef = "entityManagerFactoryRemote1",
        transactionManagerRef = "transactionManagerRemote1",
        basePackages = {"com.tykj.transfer.dao"}
)
@EnableConfigurationProperties(JpaProperties.class)
public class RemoteConfig1 {
    @Autowired
    @Qualifier("remoteDataSource1")
    private DataSource remoteDataSource;

    @Autowired
    private HibernateProperties properties;

    @Bean(name = "entityManagerRemote1")
    public EntityManager entityManager(EntityManagerFactoryBuilder builder) {
        return entityManagerFactoryRemote1(builder).getObject().createEntityManager();
    }

    @Bean(name = "entityManagerFactoryRemote1")
    public LocalContainerEntityManagerFactoryBean entityManagerFactoryRemote1(EntityManagerFactoryBuilder builder) {
        return builder
                .dataSource(remoteDataSource)
                .properties(properties.determineHibernateProperties(jpaProperties.getProperties(), new
                        HibernateSettings()))
                .packages("com.tykj.transfer.entity")
                .persistenceUnit("remotePersistenceUnit1")
                .build();
    }

    @Autowired
    private JpaProperties jpaProperties;


    private Map<String, String> getVendorProperties() {
        return jpaProperties.getProperties();
    }


    @Bean(name = "transactionManagerRemote1")
    public PlatformTransactionManager transactionManagerRemote(EntityManagerFactoryBuilder builder) {
        return new JpaTransactionManager(entityManagerFactoryRemote1(builder).getObject());
    }
}
