package com.tykj.transfer.config;

import com.alibaba.druid.spring.boot.autoconfigure.DruidDataSourceBuilder;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

import javax.sql.DataSource;

@ComponentScan
@Configuration
@Slf4j
public class DataSourceConfig {

    /**
     * pre_dc
     */
    @Primary
    @Bean(name = "locationDataSource")
    @Qualifier("locationDataSource")
    @ConfigurationProperties(prefix = "spring.datasource.local")
    public DataSource primaryDataSource() {
        log.info("本地数据源创建中————");
        return DruidDataSourceBuilder.create()
                .build();
    }

    /**
     * bus_internal_activity
     */
    @Bean(name = "remoteDataSource1")
    @Qualifier("remoteDataSource1")
    @ConfigurationProperties(prefix="spring.datasource.remote1")
    public DataSource secondaryDataSource1() {
        log.info("远程数据源创建中————");
        return DruidDataSourceBuilder.create()
                .build();
    }

    /**
     * yl_pre
     */
    @Bean(name = "remoteDataSource2")
    @Qualifier("remoteDataSource2")
    @ConfigurationProperties(prefix="spring.datasource.remote2")
    public DataSource secondaryDataSource2() {
        log.info("远程数据源创建中————");
        return DruidDataSourceBuilder.create()
                .build();
    }
}
