package com.tykj.transfer.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.*;
import java.util.Date;

/**
 * entity class for activity_applies
*/
@Data
@Entity
@ApiModel("培训人")
@Table(name = "share_yl_activity_applies",schema = "activity_applies")
//@Where(clause = "DATA_ACTIVE_STATUS = '1'")
public class ActivityApply {

	/**
	* id
	*/
	@Id
	@Column(name = "id")
	@ApiModelProperty(name = "id")
	private Long id;
	/**
	* 活动id
	*/
	@Column(name = "activyty_id")
	@ApiModelProperty(name = "活动id")
	private Long activytyId;
	/**
	* 姓名
	*/
	@Column(name = "name")
	@ApiModelProperty(name = "姓名")
	private String name;
	/**
	* 男 女
	*/
	@Column(name = "gender")
	@ApiModelProperty(name = "男 女")
	private String gender;
	/**
	* 年龄123456
	*/
	@Column(name = "age")
	@ApiModelProperty(name = "年龄123456")
	private Integer age;
	/**
	* 电话
	*/
	@Column(name = "phone")
	@ApiModelProperty(name = "电话")
	private String phone;
	/**
	* createdAt
	*/
	@Column(name = "created_at")
	@ApiModelProperty(name = "null")
	private Date createdAt;
	/**
	* updatedAt
	*/
	@Column(name = "updated_at")
	@ApiModelProperty(name = "null")
	private Date updatedAt;

	@Transient
	@Column(name = "area")
	@ApiModelProperty(name = "区域")
	private String area;

	@Transient
	@Column(name = "branch")
	@ApiModelProperty(name = "网点")
	private Long branch;

	/**
	 * 状态 1：正常 0：已删除
	 */
	@Column(name = "DATA_ACTIVE_STATUS")
	@ApiModelProperty(name = "状态 1：正常 0：已删除")
	private String dataActiveStatus;
	@Column(name = "DATA_EXCEPTION")
	private String dataException;
	@Column(name = "DATA_STATE")
	private String dataState;
	@Column(name = "DATA_UPDATE_TIME")
	private String dataUpdateTime;
}
