package com.tykj.transfer.entity.vo;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("科普专项大屏视图")
public class PageVo {
    /**
     * 累计培训人数
     */
    @ApiModelProperty(name = "累计培训人数")
    private long trainCount = 0;

    /**
     * 科技志愿者数量
     */
    @ApiModelProperty(name = "科技志愿者总量")
    private long volunteerCount = 0;

    /**
     * 网点数量
     */
    @ApiModelProperty(name = "网点数量")
    private long branchesCount = 0;


    /**
     * 男女统计
     */
    @ApiModelProperty(name = "男女统计")
    private Map<String,Long> sexCount = new HashMap<>();

    /**
     * 年龄分布统计
     */
    @ApiModelProperty(name = "年龄分布统计")
    private Map<Integer,Long> ageCounter = new HashMap<>();


    /**
     * 志愿者学历统计
     */
    @ApiModelProperty(name = "志愿者学历统计")
    private Map<String,Long> eduCount = new HashMap<>();

    /**
     * 政治面貌统计
     */
    @ApiModelProperty(name = "政治面貌统计")
    private Map<Integer,Long> faceCount = new HashMap<>();

    /**
     * 从业类别统计
     */
    @ApiModelProperty(name = "从业类别统计")
    private Map<Integer,Long> workTypeCount = new HashMap<>();

    /**
     * 网点排序
     */
    @ApiModelProperty(name = "明星服务队")
    private List<BranchesVo> branchesList = new ArrayList<>();

    /**
     *  地图数据和两个柱状图数据
     */
    @ApiModelProperty(name = "地图数据和两个柱状图数据")
    private Map<String, AreaDataVo> area = new HashMap<>();
}
