package com.tykj.transfer.excel;

import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelTarget;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import javax.persistence.Column;
import java.util.Date;

/**
 * @author:zhoushaopan
 * @create:2024/7/15
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ExcelTarget("branchTrainStatExcelVO")
public class BranchTrainStatExcelVO {

    @Excel(name = "主键")
    private String id;

    @Excel(name = "地区编码")
    private String regionCode;

    @Excel(name = "网点名称")
    private String branchName;

    @Excel(name = "培训人数")
    private String trainNum;

    @Excel(name = "数据更新时间",importFormat = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    /**
     * 业务库数据产生时间
     */
    @Column(name = "Biz_time")
    private Date bizTime;
    /**
     * 数据仓数据记录时间
     */
    @Column(name = "load_time")
    private Date loadTime;

    /**
     * op
     */
    private String op;
    /**
     * tongTime
     */
    private Date tongTime;
    /**
     * tongId
     */
    private Long tongId;

}
