package com.tykj.transfer.slave_service.impl;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.tykj.transfer.local_dao.YlActivityStatisticsDao;
import com.tykj.transfer.local_entity.YlActivityStatistics;
import com.tykj.transfer.slave_dao.Biz088DcActivityStatisticsDao;
import com.tykj.transfer.slave_service.Biz088DcActivityStatisticsService;
import com.tykj.transfer.dao.ActivitiesDao;
import com.tykj.transfer.entity.Activity;
import com.tykj.transfer.pojo.Biz088DcActivityStatistics;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.transaction.RollbackException;
import javax.transaction.Transactional;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Service
@Slf4j
public class Biz088DcActivityStatisticsServiceImpl implements Biz088DcActivityStatisticsService {

    @Resource
    private ActivitiesDao activitiesDao;

    @Resource
    private Biz088DcActivityStatisticsDao biz088DcActivityStatisticsDao;

    @Resource
    private YlActivityStatisticsDao ylActivityStatisticsDao;

    @Override
//    @Transactional
    public void transferActivity() {


//        Date from = Date.from(LocalDateTime.now().minusWeeks(1L).toInstant(ZoneOffset.of("+8")));
//        List<Activity> all = activitiesDao.findAllByCreatedAtAfter(from);
        List<Activity> all = activitiesDao.findAll();
        int total = all.size();
        int i = 0;
        Timestamp date = new Timestamp(new Date().getTime());
        List<Biz088DcActivityStatistics> rs = new ArrayList<>();
        for (Activity activity : all) {
            String jsonString = JSON.toJSONString(activity);
            Biz088DcActivityStatistics newObj = JSON.parseObject(jsonString, Biz088DcActivityStatistics.class);
            newObj.setBizTime(date);
            newObj.setLoadTime(date);
            if (!StringUtils.equals(activity.getDataActiveStatus(), "1")) {
                newObj.setOp("delete");
            }
            newObj.setTongTime(date);
            newObj.setTongId(0L);
            try {
                newObj.setIntroduction(filterEmojis(newObj.getIntroduction()));
            } catch (Exception e) {
                e.printStackTrace();
                log.error("{}", e);
            }
            try {

                // 过滤手机号
                newObj.setLatitude(latLon(newObj.getLatitude()));
                newObj.setLongitude(latLon(newObj.getLongitude()));


                newObj.setContactPerson(replacePhone(newObj.getContactPerson()));
//                newObj.setIntroduction(replacePhone(newObj.getIntroduction()));
                newObj.setAdscriptionOrg(replacePhone(newObj.getAdscriptionOrg()));

                biz088DcActivityStatisticsDao.save(newObj);
                YlActivityStatistics ylActivityStatistics = new YlActivityStatistics();
                BeanUtils.copyProperties(newObj, ylActivityStatistics);
                ylActivityStatisticsDao.save(ylActivityStatistics);
            } catch (Exception e) {
                log.error("{}", e.toString());
                e.printStackTrace();
            }
            rs.add(newObj);

            // 计数
            i++;
            if (i % 100 == 0) {
                log.info("{}/{}", i, total);
            }

        }
        log.info("活动转移完成");
    }

    public static String filterEmojis(String text) {
        if (text == null) {
            return "";
        }
        // 使用正则表达式匹配表情包字符
        String regex = "[\\x{1F600}-\\x{1F64F}\\x{1F300}-\\x{1F5FF}\\x{1F680}-\\x{1F6FF}\\x{1F700}-\\x{1F77F}\\x{1F780}-\\x{1F7FF}\\x{1F800}-\\x{1F8FF}\\x{1F900}-\\x{1F9FF}\\x{1FA00}-\\x{1FA6F}\\x{1FA70}-\\x{1FAFF}\\x{1FAB0}-\\x{1FAB6}\\x{1FAC0}-\\x{1FAC2}\\x{1FAD0}-\\x{1FAD6}\\x{1FAD8}\\x{1FAD9}\\x{1FADA}]";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(text);

        // 使用空格替换匹配到的表情包字符
        String filteredText = matcher.replaceAll(" ");
        return filteredText;
    }


    public static boolean isNumericZidai(String str) {
        for (int i = 0; i < str.length(); i++) {
            System.out.println(str.charAt(i));
            if (!Character.isDigit(str.charAt(i))) {
                return false;
            }
        }
        return true;
    }


    public static String findContinuousDigits(String input, int length) {
        // 构建正则表达式，匹配连续的指定长度的数字
        String regex = "\\d{" + length + "}";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(input);

        if (matcher.find()) {
            return matcher.group();
        } else {
            return null;
        }
    }

    public static String replacePhone(String s) {
        if (s == null) {
            return "";
        }
        String continuousDigits = findContinuousDigits(s, 11);
        if ( continuousDigits!= null) {
            String replace = s.replace(continuousDigits, "");
            log.info("替换情况:{} -> {}", s, replace);
            return replace;
        } else {
            return s;
        }
    }

    public static String latLon(String s) {
        if (s ==null || !s.contains(".")) {
            return "";
        }

        String[] split = s.split("\\.");

        int length2 = split[1].length();
        if (length2>6) {
            String s1 = split[1];
            String substring = s1.substring(0, 6);
            String rs = split[0] + "." + substring;
            log.info("经纬度替换:{}->{}", s, rs);
            return rs;
        }
        return s;
    }


    public static void main(String[] args) {
        System.out.println(findContinuousDigits(" \n" +
                "<script>\n" +
                "  window.ENV = window.ggconfig = {\"waterFall\":\"YySoEF\",\"detailRecommend\":\"qsdVZV\",\"indexRecommend\":\"SV1siw\",\"detail_aside_gg_2\":\"2KQszu\",\"comment_bottom_gg\":\"dusOBv_1999227\",\"detail_aside_gg_3\":\"xW7yoY_2013341\",\"detail_aside_gg_4\":\"h0W0wW\",\"detail_aside_gg_1\":\"jDAIfk_2013324\",\"detail_comment_top_gg1\":\"DJGw7y\",\"detail_comment_top_gg\":\"J7pfVk\",\"home_aside_gg_3\":\"JucSwF\",\"home_aside_gg_2\":\"LcUX7A\",\"news24\":\"v24xz1\",\"detail_aside_gg_5\":\"V8VJcw\",\"comment_gg\":\"gHLkOR_2343083\",\"detail_content_top_gg\":\"GuKwSv_2064424\",\"detail_pic_gg\":\"\",\"btc\":\"SDYzsK\",\"new_home_waterFall\":\"JFE0mB\",\"new_home_news24\":\"Z28n1t\",\"new_home_indexRecommend\":\"8yLvE8\",\"new_home_aside_gg_2\":\"gsCJHA\",\"show_pic_gg\":false,\"waterfall_gg_n\":{\"detail\":{\"START\":0,\"STEP\":3},\"home\":{\"START\":2,\"STEP\":3},\"ndetail\":{\"START\":0,\"STEP\":[1,2]}},\"new_home\":true,\"webp\":false,\"new_detail_waterFall\":\"hHI0ZV\",\"new_detail_news24\":{\"id\":\"WPU6sr\",\"row\":8,\"col\":3,\"pos\":[2,4,6,8,10,12,14,16,18,20,22,24],\"style\":\"col3\"},\"relate_gg\":{\"id\":\"nnfNe7\",\"pos\":[1,3,5,7,9,11,13,15,17,19,21,23]},\"popup_gg\":\"oDRR2M\",\"content_title_gg\":\"Uzm2KI\",\"comment_bottom_js_gg\":\"\",\"detail_bottom_left_gg\":\"l4BNih_2343091\",\"detail_bottom_right_gg\":\"0bauCf_2343090\",\"ndetail\":true,\"content_bottom_one_js\":true,\"comment\":false,\"hide_relate_news\":false,\"news24_recommend_exchange_position\":true,\"detail_pic_gg_2\":\"\",\"btn_refresh_pos\":\"middle\",\"all_people_see_gg\":\"\",\"author_bottom_all_people_see\":false,\"bucket\":12,\"_eds_id_\":3649,\"popug_gg_bounceIn_style\":true,\"event_bg_wall_gg\":[{\"linkUrl\":\"https:\\/\\/s.click.taobao.com\\/t?e=m%3D2%26s%3DUDS9L5P90bgcQipKwQzePCperVdZeJviK7Vc7tFgwiFRAdhuF14FMaoY22eTiCR5J1gyddu7kN8D6MZ%2Bql29yIW%2FXPHWPSQpN2yQOQl2meVsJ4%2BKPUYCzJ3PLI70IiRVfkwHTg4TQaeOJ2XZVrYPybh9YVht%2FlWEjPobR%2B9Wl%2BoGUUcdOTOM78t2Q9%2B4hwiDxquIk%2Fg7%2BcMvIAIHRmVEk3aH9JtUKSe2bauJldkSeEBxKmPmpIKZsA%3D%3D\",\"grayImgUrl\":\"http:\\/\\/p0.qhimg.com\\/t01908aa4a3a716a40c.png\",\"colorImgUrl\":\"http:\\/\\/p0.qhimg.com\\/t017fa09b4836e2e5b7.png\",\"showTime\":{\"start\":{\"year\":2019,\"month\":5,\"date\":30},\"end\":{\"year\":2019,\"month\":6,\"date\":18}}}],\"resupdate_ssl_support\":true,\"tuji\":true,\"pure_tuji\":true,\"tuji_popup_carousel_gg\":\"\",\"exp_tuji_desc_bottom_rec_gg\":\"Rm7O8i_2353065\",\"tuji_barrage_gg\":\"aFHDvx\",\"exp_tuji_rec_gg\":\"ptHhA5\",\"tuji_wenzi_gg\":\"FB9fRZ\",\"exp_tuji_last_rec_gg\":\"P6J2Lq\",\"bg_wall_gg\":\"gtos8Q\",\"ndetail_tuji_switch\":false,\"popup\":\"\",\"tuji_popup_gg\":\"lsOkP2\",\"waterfall_insert_text_ad\":true,\"subscribe\":true,\"comic_bottom_left_gg\":\"HuEL5r_2360748\",\"comic_detail_waterFall\":{\"id\":\"rDthE4\",\"START\":1,\"STEP\":3},\"comic_bottom_right_gg\":\"CyqDDv_2360749\",\"author_card_ad\":false,\"hide_author_card\":true,\"article_info\":true,\"crypto\":true,\"cube_force_purphv\":\"QnCaKiS68Hn\\nQnCGdNvD3jd\",\"p2pvideo\":true,\"economic_channel_ad\":{\"start\":\"1603123200000\",\"end\":\"1603987200000\",\"img_src\":\"https:\\/\\/p0.ssl.img.360kuai.com\\/t0117de56eda8c11d66.jpg\",\"url\":\"https:\\/\\/c.ssp.360.cn\\/t?type=19&pub=1153552_899282_2380668&cus=0_0_0_20414_0&url=http%3A%2F%2Fwww.xafy.edu.cn%2F\"},\"videodetail_append_data\":true,\"detail_top_banner\":{\"start\":1603209600000,\"end\":1605110400000,\"img\":\"https:\\/\\/p4.ssl.img.360kuai.com\\/t013308206a2c408ae5.jpg\",\"url\":\"https:\\/\\/s.click.taobao.com\\/coIoJvu\"},\"detail_middle_bar_ad\":{\"start\":1603209600000,\"end\":1605110400000,\"bigimg\":\"https:\\/\\/p3.ssl.img.360kuai.com\\/t015a7be191b2a4fcd6.png\",\"bigimghover\":\"https:\\/\\/p1.ssl.img.360kuai.com\\/t0122fca7efa28ae2d3.png\",\"smallimg\":\"https:\\/\\/p3.ssl.img.360kuai.com\\/t0116ec621ae732e104.png\",\"smallimghover\":\"https:\\/\\/p2.ssl.img.360kuai.com\\/t019fb8ee4185653819.png\",\"bubble\":\"https:\\/\\/p5.ssl.img.360kuai.com\\/t01330defe20c248273.png\",\"url\":\"https:\\/\\/s.click.taobao.com\\/tbilHvu\"},\"tuji_black_sign\":\"360dh\\n360_0de6261f\\n360_8910f42c\\n360_2b4058b3\\n360_fc624efc\\n360_fcf5961b\\n360_3aa2b959\\n360_e39369d1\\n360_7bc3b157\\n360_57c3bbd1\\n360_6aa05217\\n360_df5d7b7e\\nbaike\\n360_1208a660\\n360_6d00629c\\n360_d838ecb6\\n360_79aabe15\\nlook  \\n360_aa58bd32\\n360_a9931de8\\n360_46b9a0ef\\n360_684394a8\\n360%5F684394a8\\n360_cf71a426\\n360_edf2f6aa\\n360_205bc453\\n360_5469fded\\n360_802c86e3\\n360_e26c9522\\n360_a0ab86ec\\n360_08a937e6\\n360_fe17ca07\\npctab\\n360_2f7f67d4\\n360_d058a970\\n360_06f984f8\\n360_79cf27fd\\n360_0ed9f8f8\\n360_09801ce2\\n360_101b1016\\n360_21192782\\n360_de5bc722\\n360_b7497603\\n360_7513f821\\n360_e8841d4a\\n360_3fbc9d35\\n360_c58990f0\\n\\n\\n\",\"no_comment_qid\":[\"2779554476\"],\"pendant_interactive_gg\":\"\",\"detail_festival_skin\":{\"start\":\"1612368000000\",\"end\":\"1614355200000\",\"icon\":\"https:\\/\\/p2.ssl.img.360kuai.com\\/t0131e4ca6c78cfb2dd.png\",\"img\":\"https:\\/\\/p1.ssl.img.360kuai.com\\/t01c1dbbdef15181826.gif\"},\"nexttuji_leftflow_gg\":{\"id\":\"7nsMQI\",\"pos\":{\"START\":1,\"STEP\":3}},\"nexttuji_contentcard_lastpage_bgg\":\"YV1We2\",\"nexttuji_rightcontent_bottomgg\":{\"id\":\"fvbrHU\",\"pos\":{\"START\":1,\"STEP\":2}},\"wonderful_gallery\":false,\"preview_pic_mode\":true,\"detail_flow_related\":true,\"detail_video_relate_next\":true,\"detail_car_inquiry_modal\":true,\"attention_card\":4,\"detail_zmtlist_card\":true,\"event_fullscreen_modal_gg\":\"J6tceR\",\"footer_ad\":{\"frequency\":2,\"id\":\"vZQmw5\"},\"home_festival_page_body_bg_small\":\"https:\\/\\/p5.ssl.img.360kuai.com\\/t012c12e161c6f7a3e1.png\",\"home_festival_page_body_bg_small_new_version\":\"https:\\/\\/p3.ssl.img.360kuai.com\\/t010bbcb9418dbc760d.png\",\"home_festival_page_body_bg_color\":\"#b81b0c\",\"home_festival_page_body_bg_normal_new_version\":\"https:\\/\\/p1.ssl.img.360kuai.com\\/t01ff43bb12b76a42fa.png\",\"home_festival_page_body_bg_normal\":\"https:\\/\\/p0.ssl.img.360kuai.com\\/t01fafbd86ebaab1ea1.png\",\"home_festival_page_header_bg\":\"https:\\/\\/p1.ssl.img.360kuai.com\\/t018a647e7043b06a0e.png\",\"home_festival_end_time\":1625587200000,\"home_festival_start_time\":1624377600000,\"detail_tuji_attention_tooltip\":true,\"game_top_ad\":true,\"left_flow_refresh_topbar\":300,\"zmtkch_gg_step\":3,\"zmtkch_gg_start\":2,\"zmtkch_gg_showid\":\"kY3CU4\",\"article_bottom_gg\":\"\",\"flowIdleTime\":1,\"videodetail_relate_gg\":{\"id\":\"QdAYZ6\",\"pos\":{\"START\":2,\"STEP\":1}},\"new_detail_waterFall_searchad\":\"s3bfc48c999\",\"new_detail_waterfall_modal_gg\":\"61JoAM\",\"video_player_after_gg_countdown\":1060010,\"ndetail_right_aside_top_gg\":\"JIBGJ0_2350023\",\"video_player_after_gg_min_time\":180,\"article_text_gg\":{\"id\":\"P4Y89g\",\"pos\":[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20]},\"video_player_pause_gg\":\"YHKAry\",\"detail_version\":3,\"videodetail_feed_gg\":{\"id\":\"ESN6ch\",\"pos\":{\"START\":\"0\",\"STEP\":\"3\"}},\"content_bottom_showcase_gg\":\"c2kbYM\",\"ndetail_article_right_aside\":true,\"ndetail_right_aside_content_gg\":\"uHYxUo\",\"article_share_bottom_showcase_gg\":\"N8rV9n\",\"video_player_after_gg\":\"u6bTCG\",\"hide_content_font_feature\":true,\"detail_follow_zmtlist\":true,\"sign\":\"360_57c3bbd1\"};\n" +
                "  if(window.ggconfig.hide_relate_news) {\n" +
                "    // 相关新闻不显示的话底部广告不显示\n" +
                "    window.ggconfig.detail_bottom_left_gg = '';\n" +
                "    window.ggconfig.detail_bottom_right_gg = '';\n" +
                "  }\n" +
                "</script>", 11));
    }


}
