package com.tykj.transfer.slave_service.impl;

import com.alibaba.fastjson.JSON;
import com.tykj.transfer.local_dao.RegionModelRepository;
import com.tykj.transfer.local_entity.RegionModelDo;
import com.tykj.transfer.entity.vo.PageVo;
import com.tykj.transfer.local_dao.YlTrainStatisticsDao;
import com.tykj.transfer.local_entity.YlBranchTrainStatistics;
import com.tykj.transfer.local_entity.YlTrainStatistics;
import com.tykj.transfer.pojo.Biz088DcTrainStatistics;
import com.tykj.transfer.slave_dao.Biz088DcTrainStatisticsDao;
import com.tykj.transfer.slave_service.Biz088DcTrainStatisticsService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.transaction.Transactional;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Service
@Slf4j
public class Biz088DcTrainStatisticsImpl implements Biz088DcTrainStatisticsService {

    @Resource
    private RegionModelRepository regionModelRepository;

    @Resource
    private StringRedisTemplate stringRedisTemplate;

    @Resource
    private Biz088DcTrainStatisticsDao biz088DcTrainStatisticsDao;

    @Resource
    private YlTrainStatisticsDao ylTrainStatisticsDao;

    @Override
//    @Transactional
    public void transferTrain() {
        // 先存储省级的培训人数信息
        List<Biz088DcTrainStatistics> rs = new ArrayList<>();
        List<YlTrainStatistics> localList=new ArrayList<>();
        Date date = new Date();
        String yyyyMMdd = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));

        String s = stringRedisTemplate.opsForValue().get("330000YlTotal");
        PageVo pageVo = JSON.parseObject(String.valueOf(s), PageVo.class);
        Biz088DcTrainStatistics provinceVo = new Biz088DcTrainStatistics();
        provinceVo.setRegionCode("330000");
        provinceVo.setTrainNum(String.valueOf(pageVo.getTrainCount()));
        Map<String, Long> sexCount = pageVo.getSexCount();
        provinceVo.setMailNum(String.valueOf(sexCount.get("男")));
        provinceVo.setFemailNum(String.valueOf(sexCount.get("女")));
        Map<Integer, Long> ageCounter = pageVo.getAgeCounter();
        provinceVo.setAgeRangeNum1(String.valueOf(ageCounter.get(1)));
        provinceVo.setAgeRangeNum2(String.valueOf(ageCounter.get(2)));
        provinceVo.setAgeRangeNum3(String.valueOf(ageCounter.get(3)));
        provinceVo.setAgeRangeNum4(String.valueOf(ageCounter.get(4)));
        provinceVo.setAgeRangeNum5(String.valueOf(ageCounter.get(5)));
        provinceVo.setAgeRangeNum6(String.valueOf(ageCounter.get(6)));
        provinceVo.setUpdateTime(date);
        provinceVo.setBizTime(date);
        provinceVo.setLoadTime(date);
        provinceVo.setTongTime(date);
        provinceVo.setTongId(0L);

        YlTrainStatistics localProvince=new YlTrainStatistics();
        BeanUtils.copyProperties(provinceVo,localProvince);
        List<RegionModelDo> regionVoList = regionModelRepository.getRegionVo("330000");
        for (RegionModelDo regionModelDo : regionVoList) {
            String city = stringRedisTemplate.opsForValue().get(regionModelDo.getCode() + "YlTotal");
            PageVo cityPageVo = JSON.parseObject(String.valueOf(city), PageVo.class);
            Biz088DcTrainStatistics cityVo = new Biz088DcTrainStatistics();
            cityVo.setRegionCode(regionModelDo.getCode());
            cityVo.setTrainNum(String.valueOf(cityPageVo.getTrainCount()));
            Map<String, Long> citySexCount = cityPageVo.getSexCount();
            cityVo.setMailNum(String.valueOf(citySexCount.get("男")));
            cityVo.setFemailNum(String.valueOf(citySexCount.get("女")));
            Map<Integer, Long> cityAgeCounter = cityPageVo.getAgeCounter();
            cityVo.setAgeRangeNum1(String.valueOf(cityAgeCounter.get(1)));
            cityVo.setAgeRangeNum2(String.valueOf(cityAgeCounter.get(2)));
            cityVo.setAgeRangeNum3(String.valueOf(cityAgeCounter.get(3)));
            cityVo.setAgeRangeNum4(String.valueOf(cityAgeCounter.get(4)));
            cityVo.setAgeRangeNum5(String.valueOf(cityAgeCounter.get(5)));
            cityVo.setAgeRangeNum6(String.valueOf(cityAgeCounter.get(6)));
            cityVo.setUpdateTime(date);
            cityVo.setBizTime(date);
            cityVo.setLoadTime(date);
            cityVo.setTongTime(date);
            cityVo.setTongId(0L);
            YlTrainStatistics localCity=new YlTrainStatistics();
            BeanUtils.copyProperties(cityVo,localCity);
            localList.add(localCity);
            rs.add(cityVo);

            List<RegionModelDo> streetVoList = regionModelRepository.getRegionVo(regionModelDo.getCode());
            for (RegionModelDo modelDo : streetVoList) {
                String street = stringRedisTemplate.opsForValue().get(modelDo.getCode() + "YlTotal");
                PageVo streetPageVo = JSON.parseObject(String.valueOf(street), PageVo.class);
                Biz088DcTrainStatistics streetVo = new Biz088DcTrainStatistics();
                streetVo.setRegionCode(modelDo.getCode());
                streetVo.setTrainNum(String.valueOf(streetPageVo.getTrainCount()));
                Map<String, Long> streetSexCount = streetPageVo.getSexCount();
                streetVo.setMailNum(String.valueOf(streetSexCount.get("男")));
                streetVo.setFemailNum(String.valueOf(streetSexCount.get("女")));
                Map<Integer, Long> streetAgeCounter = streetPageVo.getAgeCounter();
                streetVo.setAgeRangeNum1(String.valueOf(streetAgeCounter.get(1)));
                streetVo.setAgeRangeNum2(String.valueOf(streetAgeCounter.get(2)));
                streetVo.setAgeRangeNum3(String.valueOf(streetAgeCounter.get(3)));
                streetVo.setAgeRangeNum4(String.valueOf(streetAgeCounter.get(4)));
                streetVo.setAgeRangeNum5(String.valueOf(streetAgeCounter.get(5)));
                streetVo.setAgeRangeNum6(String.valueOf(streetAgeCounter.get(6)));
                streetVo.setUpdateTime(date);
                streetVo.setBizTime(date);
                streetVo.setLoadTime(date);
                streetVo.setTongTime(date);
                streetVo.setTongId(0L);
                YlTrainStatistics localStreet=new YlTrainStatistics();
                BeanUtils.copyProperties(streetVo,localStreet);
                localList.add(localStreet);
                rs.add(streetVo);
            }
        }
        rs.add(provinceVo);
        localList.add(localProvince);
        for (Biz088DcTrainStatistics r : rs) {
            r.setId(yyyyMMdd + r.getRegionCode());
        }
        for (YlTrainStatistics ylTrainStatistics : localList) {
            ylTrainStatistics.setId(yyyyMMdd + ylTrainStatistics.getRegionCode());
        }
        biz088DcTrainStatisticsDao.saveAll(rs);
        ylTrainStatisticsDao.saveAll(localList);
        log.info("网点转移完成,成功转移了{}条", rs.size());
    }
}
