package com.tykj.transfer.slave_service.impl;

import com.alibaba.fastjson.JSON;
import com.tykj.transfer.local_dao.RegionModelRepository;
import com.tykj.transfer.local_entity.RegionModelDo;
import com.tykj.transfer.entity.vo.PageVo;
import com.tykj.transfer.local_dao.YlVolunteerStatisticsDao;
import com.tykj.transfer.local_entity.YlTrainStatistics;
import com.tykj.transfer.local_entity.YlVolunteerStatistics;
import com.tykj.transfer.pojo.Biz088DcVolunteerStatistics;
import com.tykj.transfer.slave_dao.Biz088DcVolunteerStatisticsDao;
import com.tykj.transfer.slave_service.Biz088DcVolunteerStatisticsService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.transaction.Transactional;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Service
@Slf4j
public class Biz088DcVolunteerStatisticsImpl implements Biz088DcVolunteerStatisticsService {

    @Resource
    private RegionModelRepository regionModelRepository;

    @Resource
    private StringRedisTemplate stringRedisTemplate;

    @Resource
    private Biz088DcVolunteerStatisticsDao biz088DcVolunteerStatisticsDao;

    @Resource
    private YlVolunteerStatisticsDao ylVolunteerStatisticsDao;

    @Override
//    @Transactional
    public void transferVolunteer() {
        String yyyyMMdd = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));

        String s = stringRedisTemplate.opsForValue().get("330000YlTotal");
        List<Biz088DcVolunteerStatistics> rs=new ArrayList<>();
        List<YlVolunteerStatistics> localList=new ArrayList<>();
        PageVo pageVo = JSON.parseObject(String.valueOf(s), PageVo.class);
        Date date=new Date();
        Biz088DcVolunteerStatistics provinceVo=new Biz088DcVolunteerStatistics();
        provinceVo.setRegionCode("330000");
        provinceVo.setVolunteerNum(String.valueOf(pageVo.getVolunteerCount()));
        Map<Integer, Long> faceCount = pageVo.getFaceCount();
        Map<String, Long> eduCount = pageVo.getEduCount();
        Map<Integer, Long> workTypeCount = pageVo.getWorkTypeCount();
        provinceVo.setPoliticalTypeNums(JSON.toJSONString(faceCount).replaceAll("\\{|}", ""));
        provinceVo.setWorkTypeNums(JSON.toJSONString(eduCount).replaceAll("\\{|}", ""));
        provinceVo.setEducationTypeNums(JSON.toJSONString(workTypeCount).replaceAll("\\{|}", ""));
        provinceVo.setUpdateTime(date);
        provinceVo.setBizTime(date);
        provinceVo.setLoadTime(date);
        provinceVo.setTongTime(date);
        provinceVo.setTongId(0L);
        YlVolunteerStatistics localProvince=new YlVolunteerStatistics();
        BeanUtils.copyProperties(provinceVo,localProvince);
        localList.add(localProvince);
        rs.add(provinceVo);
        List<RegionModelDo> regionVoList = regionModelRepository.getRegionVo("330000");
        for (RegionModelDo regionModelDo : regionVoList) {
            String city = stringRedisTemplate.opsForValue().get(regionModelDo.getCode() + "YlTotal");
            PageVo cityPageVo = JSON.parseObject(String.valueOf(city), PageVo.class);
            Biz088DcVolunteerStatistics cityVo=new Biz088DcVolunteerStatistics();
            cityVo.setRegionCode(regionModelDo.getCode());
            cityVo.setVolunteerNum(String.valueOf(cityPageVo.getVolunteerCount()));
            Map<Integer, Long> cityFaceCount = cityPageVo.getFaceCount();
            Map<String, Long> cityEduCount = cityPageVo.getEduCount();
            Map<Integer, Long> cityWorkTypeCount = cityPageVo.getWorkTypeCount();
            cityVo.setPoliticalTypeNums(JSON.toJSONString(cityFaceCount).replaceAll("\\{|}", ""));
            cityVo.setWorkTypeNums(JSON.toJSONString(cityEduCount).replaceAll("\\{|}", ""));
            cityVo.setEducationTypeNums(JSON.toJSONString(cityWorkTypeCount).replaceAll("\\{|}", ""));
            cityVo.setUpdateTime(date);
            cityVo.setBizTime(date);
            cityVo.setLoadTime(date);
            cityVo.setTongTime(date);
            cityVo.setTongId(0L);
            YlVolunteerStatistics localCity=new YlVolunteerStatistics();
            BeanUtils.copyProperties(cityVo,localCity);
            localList.add(localCity);
            rs.add(cityVo);
            List<RegionModelDo> streetVoList = regionModelRepository.getRegionVo(regionModelDo.getCode());
            for (RegionModelDo modelDo : streetVoList) {
                String street = stringRedisTemplate.opsForValue().get(modelDo.getCode() + "YlTotal");
                PageVo streetPageVo = JSON.parseObject(String.valueOf(street), PageVo.class);
                Biz088DcVolunteerStatistics streetVo=new Biz088DcVolunteerStatistics();
                streetVo.setRegionCode(modelDo.getCode());
                streetVo.setVolunteerNum(String.valueOf(streetPageVo.getVolunteerCount()));
                Map<Integer, Long> streetFaceCount = streetPageVo.getFaceCount();
                Map<String, Long> streetEduCount = streetPageVo.getEduCount();
                Map<Integer, Long> streetWorkTypeCount = streetPageVo.getWorkTypeCount();
                streetVo.setPoliticalTypeNums(JSON.toJSONString(streetFaceCount).replaceAll("\\{|}", ""));
                streetVo.setWorkTypeNums(JSON.toJSONString(streetEduCount).replaceAll("\\{|}", ""));
                streetVo.setEducationTypeNums(JSON.toJSONString(streetWorkTypeCount).replaceAll("\\{|}", ""));
                streetVo.setUpdateTime(date);
                streetVo.setBizTime(date);
                streetVo.setLoadTime(date);
                streetVo.setTongTime(date);
                streetVo.setTongId(0L);
                YlVolunteerStatistics streetCity=new YlVolunteerStatistics();
                BeanUtils.copyProperties(streetVo,streetCity);
                localList.add(streetCity);
                rs.add(streetVo);
            }
        }
        for (Biz088DcVolunteerStatistics r : rs) {
            r.setId(yyyyMMdd + r.getRegionCode());
        }
        for (YlVolunteerStatistics ylVolunteerStatistics : localList) {
            ylVolunteerStatistics.setId(yyyyMMdd + ylVolunteerStatistics.getRegionCode());
        }
        biz088DcVolunteerStatisticsDao.saveAll(rs);
        ylVolunteerStatisticsDao.saveAll(localList);
        log.info("志愿者人数转移完成,成功转移了{}条", rs.size());
    }
}
