package com.tykj.transfer;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@SpringBootApplication
@EnableJpaAuditing
@EnableSwagger2
@EnableTransactionManagement
@EnableScheduling
@EnableCaching
@ComponentScan(basePackages = {"com.tykj.transfer.*"})
public class YlTransferApplication {

    public static void main(String[] args) {
        SpringApplication.run(YlTransferApplication.class, args);
    }

}
