package com.tykj.transfer.controller;

import com.tykj.transfer.slave_service.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * @author syk
 */
@Api(tags = "银铃活动 网点数据转移")
@RestController
@RequestMapping("/yl")
public class transferController {

    @Resource
    private Biz088DcNetworkStatisticsService biz088DcNetworkStatisticsService;

    @Resource
    private Biz088DcActivityStatisticsService biz088DcActivityStatisticsService;

    @Resource
    private Biz088DcBranchTrainStatisticsService biz088DcBranchTrainStatisticsService;

    @Resource
    private Biz088DcTrainStatisticsService biz088DcTrainStatisticsService;

    @Resource
    private Biz088DcVolunteerStatisticsService biz088DcVolunteerStatisticsService;

    @GetMapping("/tranBranch")
    @ApiOperation("网点数据转移")
    public void tranBranch() {
        biz088DcNetworkStatisticsService.transferBranch();
    }

    @GetMapping("/tranActivity")
    @ApiOperation("活动数据转移")
    public void tranActivity() {
       biz088DcActivityStatisticsService.transferActivity();
    }

    @GetMapping("/transferBranchApply")
    @ApiOperation("网点培训人数转移")
    public void transferBranchApply() {
        biz088DcBranchTrainStatisticsService.transferBranchApply();
    }


    @GetMapping("/transferTrain")
    @ApiOperation("培训人数转移")
    public void transferTrain(){
        biz088DcTrainStatisticsService.transferTrain();
    }

    @GetMapping("/transferVolunteer")
    @ApiOperation("志愿者人数转移")
    public void transferVolunteer(){
        biz088DcVolunteerStatisticsService.transferVolunteer();
    }
}
