package com.tykj.transfer.local_entity;

import com.tykj.transfer.pojo.Biz088DcBranchTrainStatistics;
import com.tykj.transfer.pojo.YlPrimaryKeyLong;
import com.tykj.transfer.pojo.YlPrimaryKeyString;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.util.Date;
@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
@IdClass(YlPrimaryKeyString.class)
@Table(name = "yl_branch_train_statistics")
public class YlBranchTrainStatistics {
    /**
     * 主键
     */
    @Id
    @GenericGenerator(name = "idGenerator", strategy = "uuid")
    @GeneratedValue(generator = "idGenerator")
    @Column(name = "id",length = 64)
    private String id;
    /**
     * 地区编码
     */
    @Column(name = "region_code")
    private String regionCode;
    /**
     * 网点名称
     */
    @Column(name = "branch_name")
    private String branchName;
    /**
     * 培训人数
     */
    @Column(name = "train_num")
    private String trainNum;
    /**
     * 数据更新时间
     */
    @Column(name = "update_time")
    private Date updateTime;
    /**
     * 业务库数据产生时间
     */
    @Column(name = "Biz_time")
    private Date bizTime;
    /**
     * 数据仓数据记录时间
     */
    @Column(name = "load_time")
    private Date loadTime;
    /**
     * op
     */
    @Column(name = "op")
    private String op;
    /**
     * tongTime
     */
    @Column(name = "tong_time")
    private Date tongTime;
    /**
     * tongId
     */
    @Id
    @Column(name = "tongID")
    private Long tongId;


}
