package com.tykj.transfer.pojo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.util.Date;

/**
 * @author
 * entity class for biz_088_dc_volunteer_statistics
 * 银龄科技志愿者人数统计信息
*/
@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
@IdClass(YlPrimaryKeyString.class)
@Table(name = "biz_088_dc_volunteer_statistics")
public class Biz088DcVolunteerStatistics {

	/**
	* 主键
	*/
	@Id
	@GenericGenerator(name = "idGenerator", strategy = "uuid")
	@GeneratedValue(generator = "idGenerator")
	@Column(name = "id",length = 64)
	private String id;
	/**
	* 地区编码
	*/
	@Column(name = "region_code")
	private String regionCode;
	/**
	* 科技志愿者人数
	*/
	@Column(name = "volunteer_num")
	private String volunteerNum;
	/**
	* 政治面貌统计
	*/
	@Column(name = "political_type_nums")
	private String politicalTypeNums;
	/**
	* 从业类别统计
	*/
	@Column(name = "work_type_nums")
	private String workTypeNums;
	/**
	* 学历结构统计
	*/
	@Column(name = "education_type_nums")
	private String educationTypeNums;
	/**
	* 数据更新时间
	*/
	@Column(name = "update_time")
	private Date updateTime;
	/**
	* 业务库数据产生时间
	*/
	@Column(name = "Biz_time")
	private Date bizTime;
	/**
	* 数据仓数据记录时间
	*/
	@Column(name = "load_time")
	private Date loadTime;
	/**
	* op
	*/
	@Column(name = "op")
	private String op;
	/**
	* tongTime
	*/
	@Column(name = "tong_time")
	private Date tongTime;
	/**
	* tongId
	*/
	@Id
	@Column(name = "tongID")
	private Long tongId;

}
