package com.tykj.transfer.slave_service.impl;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.tykj.transfer.local_dao.YlActivityStatisticsDao;
import com.tykj.transfer.local_entity.YlActivityStatistics;
import com.tykj.transfer.slave_dao.Biz088DcActivityStatisticsDao;
import com.tykj.transfer.slave_service.Biz088DcActivityStatisticsService;
import com.tykj.transfer.dao.ActivitiesDao;
import com.tykj.transfer.entity.Activity;
import com.tykj.transfer.pojo.Biz088DcActivityStatistics;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.transaction.RollbackException;
import javax.transaction.Transactional;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Service
@Slf4j
public class Biz088DcActivityStatisticsServiceImpl implements Biz088DcActivityStatisticsService {

    @Resource
    private ActivitiesDao activitiesDao;

    @Resource
    private Biz088DcActivityStatisticsDao biz088DcActivityStatisticsDao;

    @Resource
    private YlActivityStatisticsDao ylActivityStatisticsDao;
    @Override
    @Transactional
    public void transferActivity() {

        Date from = Date.from(LocalDateTime.now().minusWeeks(1L).toInstant(ZoneOffset.of("+8")));
        List<Activity> all = activitiesDao.findAllByCreatedAtAfter(from);
        Timestamp date = new Timestamp(new Date().getTime());
        List<Biz088DcActivityStatistics> rs = new ArrayList<>();
        for (Activity activity : all) {
            String jsonString = JSON.toJSONString(activity);
            Biz088DcActivityStatistics newObj = JSON.parseObject(jsonString, Biz088DcActivityStatistics.class);
            newObj.setBizTime(date);
            newObj.setLoadTime(date);
            if (!StringUtils.equals(activity.getDataActiveStatus(), "1")) {
                newObj.setOp("delete");
            }
            newObj.setTongTime(date);
            newObj.setTongId(0L);
            newObj.setIntroduction(filterEmojis(newObj.getIntroduction()));
            try {
                biz088DcActivityStatisticsDao.save(newObj);
                YlActivityStatistics ylActivityStatistics=new YlActivityStatistics();
                BeanUtils.copyProperties(newObj,ylActivityStatistics);
                ylActivityStatisticsDao.save(ylActivityStatistics);
            } catch (Exception e) {
                log.error("{}", e.toString());
            }
            rs.add(newObj);
        }

//        biz088DcActivityStatisticsDao.saveAll(rs);

        log.info("活动转移完成:{}", rs.size());
    }

    public static String filterEmojis(String text) {
        if (text == null) {
            return "";
        }
        // 使用正则表达式匹配表情包字符
        String regex = "[\\x{1F600}-\\x{1F64F}\\x{1F300}-\\x{1F5FF}\\x{1F680}-\\x{1F6FF}\\x{1F700}-\\x{1F77F}\\x{1F780}-\\x{1F7FF}\\x{1F800}-\\x{1F8FF}\\x{1F900}-\\x{1F9FF}\\x{1FA00}-\\x{1FA6F}\\x{1FA70}-\\x{1FAFF}\\x{1FAB0}-\\x{1FAB6}\\x{1FAC0}-\\x{1FAC2}\\x{1FAD0}-\\x{1FAD6}\\x{1FAD8}\\x{1FAD9}\\x{1FADA}]";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(text);

        // 使用空格替换匹配到的表情包字符
        String filteredText = matcher.replaceAll(" ");
        return filteredText;
    }


}
