package com.tykj.transfer.slave_service.impl;

import com.alibaba.fastjson.JSON;
import com.tykj.transfer.dao.ActivitiesDao;
import com.tykj.transfer.dao.ActivityApplyDao;
import com.tykj.transfer.dao.BranchesDao;
import com.tykj.transfer.dao.RegionModelRepository;
import com.tykj.transfer.entity.Activity;
import com.tykj.transfer.entity.Branches;
import com.tykj.transfer.entity.vo.BranchesVo;
import com.tykj.transfer.entity.vo.PageVo;
import com.tykj.transfer.local_dao.YlBranchTrainStatisticsDao;
import com.tykj.transfer.local_entity.YlBranchTrainStatistics;
import com.tykj.transfer.pojo.Biz088DcBranchTrainStatistics;
import com.tykj.transfer.slave_dao.Biz088DcBranchTrainStatisticsDao;
import com.tykj.transfer.slave_service.Biz088DcBranchTrainStatisticsService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.transaction.Transactional;
import javax.xml.crypto.Data;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
@Service
@Slf4j
public class Biz088DcBranchTrainStatisticsImpl implements Biz088DcBranchTrainStatisticsService {

    @Resource
    private StringRedisTemplate stringRedisTemplate;

    @Resource
    private BranchesDao branchesDao;

    @Resource
    private ActivitiesDao activitiesDao;

    @Resource
    private ActivityApplyDao activityApplyDao;

    @Resource
    private Biz088DcBranchTrainStatisticsDao biz088DcBranchTrainStatisticsDao;

    @Resource
    private YlBranchTrainStatisticsDao ylBranchTrainStatisticsDao;
    @Override
    @Transactional
    public void transferBranchApply() {
        String s = stringRedisTemplate.opsForValue().get("330000YlTotal");
        PageVo pageVo = JSON.parseObject(String.valueOf(s), PageVo.class);
        List<BranchesVo> branchesList = pageVo.getBranchesList();
        List<Biz088DcBranchTrainStatistics> rs=new ArrayList<>();
        List<YlBranchTrainStatistics> listVo=new ArrayList<>();
        Date date = new Date();
        for (BranchesVo branchesVo : branchesList) {
            Biz088DcBranchTrainStatistics VO = new Biz088DcBranchTrainStatistics();
            YlBranchTrainStatistics ylBranchTrainStatistics=new YlBranchTrainStatistics();
            VO.setBranchName(branchesVo.getName());
            Branches allByName = branchesDao.findAllByName(branchesVo.getName());
            VO.setRegionCode(allByName.getArea());
            List<Activity> allByBranchId = activitiesDao.findAllByBranchId(allByName.getId());
            Long activityApplyCount=0L;
            for (Activity activity : allByBranchId) {
                activityApplyCount+= activityApplyDao.getActivityApplyCount(activity.getId());
            }
            VO.setTrainNum(String.valueOf(activityApplyCount));
            VO.setUpdateTime(date);
            VO.setBizTime(date);
            VO.setLoadTime(date);
            VO.setTongTime(date);
            VO.setTongId(0L);
            BeanUtils.copyProperties(VO,ylBranchTrainStatistics);
            listVo.add(ylBranchTrainStatistics);
            rs.add(VO);
        }
        biz088DcBranchTrainStatisticsDao.saveAll(rs);
        ylBranchTrainStatisticsDao.saveAll(listVo);
        log.info("网点培训人数转移完成,成功转移了{}条", rs.size());
    }
}
