package com.tykj.transfer.slave_service.impl;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.tykj.transfer.local_dao.YlNetworkStatisticsDao;
import com.tykj.transfer.local_entity.YlNetworkStatistics;
import com.tykj.transfer.slave_dao.Biz088DcNetworkStatisticsDao;
import com.tykj.transfer.slave_service.Biz088DcNetworkStatisticsService;
import com.tykj.transfer.dao.BranchesDao;
import com.tykj.transfer.entity.Branches;
import com.tykj.transfer.pojo.Biz088DcNetworkStatistics;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.transaction.Transactional;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import static com.tykj.transfer.slave_service.impl.Biz088DcActivityStatisticsServiceImpl.filterEmojis;

@Service
@Slf4j
public class Biz088DcNetworkStatisticsImpl implements Biz088DcNetworkStatisticsService {

    @Resource
    private BranchesDao branchesDao;

    @Resource
    private Biz088DcNetworkStatisticsDao biz088DcNetworkStatisticsDao;

    @Resource
    private YlNetworkStatisticsDao ylNetworkStatisticsDao;
    @Override
    @Transactional
    public void transferBranch() {
        List<Branches> all = branchesDao.findAll();
        Date date = new Date();
        List<Biz088DcNetworkStatistics> rs = new ArrayList<>();
        for (Branches branches : all) {
            Biz088DcNetworkStatistics newObj = JSON.parseObject( JSON.toJSONString(branches), Biz088DcNetworkStatistics.class);
            newObj.setBizTime(date);
            newObj.setLoadTime(date);
            if (!StringUtils.equals(branches.getDataActiveStatus(), "1")) {
                newObj.setOp("delete");
            }
            newObj.setTongTime(date);
            newObj.setAddress(filterEmojis(newObj.getAddress()));
            newObj.setTongId(0L);
            try {
                YlNetworkStatistics ylNetworkStatistics=new YlNetworkStatistics();
                BeanUtils.copyProperties(newObj,ylNetworkStatistics);
                biz088DcNetworkStatisticsDao.save(newObj);
                ylNetworkStatisticsDao.save(ylNetworkStatistics);
            }catch (Exception e) {
                log.error("{}", e.toString());
            }
            rs.add(newObj);
        }
        log.info("网点转移完成,成功转移了{}条", rs.size());
    }
}
