package com.tykj.transfer.local_entity;

import com.tykj.transfer.pojo.YlPrimaryKeyLong;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.util.Date;
@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
@IdClass(YlPrimaryKeyLong.class)
@Table(name = "yl_network_statistics")
public class YlNetworkStatistics {
    /**
     * 主键
     */
    @Id
//	@GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "id")
    private Long id;
    /**
     * 关联的平台用户
     */
    @Column(name = "uid")
    private Integer uid;
    /**
     * 申请的网点名
     */
    @Column(name = "name")
    private String name;
    /**
     * 网点地址
     */
    @Column(name = "address")
    private String address;
    /**
     * 联系人
     */
    @Column(name = "contact_person")
    private String contactPerson;
    /**
     * 联系电话
     */
    @Column(name = "contact_phone")
    private String contactPhone;
    /**
     * 单位类型
     */
    @Column(name = "unit_type")
    private Boolean unitType;
    /**
     * 单位名称
     */
    @Column(name = "unit_name")
    private String unitName;
    /**
     * 容量
     */
    @Column(name = "capacity")
    private String capacity;
    /**
     * 创建时间
     */
    @Column(name = "created_at")
    private Date createdAt;
    /**
     * 更新时间
     */
    @Column(name = "updated_at")
    private Date updatedAt;
    /**
     * 封面
     */
    @Column(name = "cover")
    private String cover;
    /**
     * 纬度
     */
    @Column(name = "latitude")
    private String latitude;
    /**
     * 经度
     */
    @Column(name = "longitude")
    private String longitude;
    /**
     * 街道
     */
    @Column(name = "street")
    private String street;
    /**
     * 所在区
     */
    @Column(name = "area")
    private String area;
    /**
     * 队长姓名
     */
    @Column(name = "leader_name")
    private String leaderName;
    /**
     * 队长电话
     */
    @Column(name = "leader_phone")
    private String leaderPhone;
    /**
     * 成立日期
     */
    @Column(name = "found_date")
    private Date foundDate;
    /**
     * 网点详细地址
     */
    @Column(name = "full_address")
    private String fullAddress;
    /**
     * 业务库数据产生时间
     */
    @Column(name = "Biz_time")
    private Date bizTime;
    /**
     * 数据仓数据记录时间
     */
    @Column(name = "load_time")
    private Date loadTime;
    /**
     * op
     */
    @Column(name = "op")
    private String op;
    /**
     * tongTime
     */
    @Column(name = "tong_time")
    private Date tongTime;
    /**
     * tongId
     */
    @Id
    @Column(name = "tongID")
    private Long tongId;
}
