package com.tykj.transfer.pojo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;

/**
 * @author
 * entity class for biz_088_dc_activity_statistics
 * 银龄活动统计数据信息
*/
@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
@IdClass(YlPrimaryKeyLong.class)
@Table(name = "biz_088_dc_activity_statistics")
public class Biz088DcActivityStatistics {

	/**
	* 主键
	*/
	@Id
	@Column(name = "id")
	private Long id;
	/**
	* 活动标题
	*/
	@Column(name = "title")
	private String title;
	/**
	* 封面
	*/
	@Column(name = "cover")
	private String cover;
	/**
	* 活动编码
	*/
	@Column(name = "code")
	private String code;
	/**
	* 活动类型
	*/
	@Column(name = "type")
	private String type;
	/**
	* 活动区域
	*/
	@Column(name = "area")
	private String area;
	/**
	* 详细地点
	*/
	@Column(name = "address")
	private String address;
	/**
	* 服务类别
	*/
	@Column(name = "service_type")
	private String serviceType;
	/**
	* 服务对象
	*/
	@Column(name = "service_obj")
	private String serviceObj;
	/**
	* 关联项目
	*/
	@Column(name = "project")
	private String project;
	/**
	* 主办单位
	*/
	@Column(name = "organizer")
	private String organizer;
	/**
	* 承办单位
	*/
	@Column(name = "contractor")
	private String contractor;
	/**
	* 协办单位
	*/
	@Column(name = "sponsor")
	private String sponsor;
	/**
	* 发布时间
	*/
	@Column(name = "release_time")
	private Date releaseTime;
	/**
	* 招募时间
	*/
	@Column(name = "recruit_time")
	private Date recruitTime;
	/**
	* 招募人数
	*/
	@Column(name = "recruit_number")
	private Integer recruitNumber;
	/**
	* 活动时间
	*/
	@Column(name = "activity_time")
	private Date activityTime;
	/**
	* 活动结束时间
	*/
	@Column(name = "activity_time_end")
	private Date activityTimeEnd;
	/**
	* 活动简介
	*/
	@Column(name = "introduction", columnDefinition = "TEXT")
	private String introduction;
	/**
	* 活动要求
	*/
	@Column(name = "claim")
	private String claim;
	/**
	* 所属组织
	*/
	@Column(name = "adscription_org")
	private String adscriptionOrg;
	/**
	* 联系人
	*/
	@Column(name = "contact_person")
	private String contactPerson;
	/**
	* 联系电话
	*/
	@Column(name = "contact_phone")
	private String contactPhone;
	/**
	* 联系邮箱
	*/
	@Column(name = "contact_email")
	private String contactEmail;
	/**
	* 网点编号
	*/
	@Column(name = "branch_id")
	private Integer branchId;
	/**
	* 是否签到
	*/
	@Column(name = "is_sign")
	private Boolean isSign;
	/**
	* 签到精度
	*/
	@Column(name = "sign_precision")
	private Integer signPrecision;
	/**
	* 活动状态
	*/
	@Column(name = "status")
	private Integer status;
	/**
	* 纬度
	*/
	@Column(name = "latitude")
	private String latitude;
	/**
	* 经度
	*/
	@Column(name = "longitude")
	private String longitude;
	/**
	* 人数限制
	*/
	@Column(name = "people_number")
	private Integer peopleNumber;
	/**
	* 数据创建时间
	*/
	@Column(name = "created_at")
	private Date createdAt;
	/**
	* 数据更新时间
	*/
	@Column(name = "updated_at")
	private Date updatedAt;
	/**
	* 发布管理员
	*/
	@Column(name = "admin_id")
	private Integer adminId;
	/**
	* 业务库数据产生时间
	*/
	@Column(name = "Biz_time")
	private Timestamp bizTime;
	/**
	* 数据仓数据记录时间
	*/
	@Column(name = "load_time")
	private Timestamp loadTime;
	/**
	* op
	*/
	@Column(name = "op")
	private String op;
	/**
	* tongTime
	*/
	@Column(name = "tong_time")
	private Timestamp tongTime;
	/**
	* tongId
	*/
	@Id
	@Column(name = "tongID")
	private Long tongId = 0L;

}
