package com.tykj.transfer.pojo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.util.Date;

/**
 * @author
 * entity class for biz_088_dc_train_statistics
 * 银龄培训人数统计信息
*/
@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
@IdClass(YlPrimaryKeyString.class)
@Table(name = "biz_088_dc_train_statistics")
public class Biz088DcTrainStatistics {

	/**
	* 主键
	*/
	@Id
//	@GenericGenerator(name = "idGenerator", strategy = "uuid")
//	@GeneratedValue(generator = "idGenerator")
	@Column(name = "id",length = 64)
	private String id;
	/**
	* 地区编码
	*/
	@Column(name = "region_code")
	private String regionCode;
	/**
	* 培训人次
	*/
	@Column(name = "train_num")
	private String trainNum;
	/**
	* 男性人数
	*/
	@Column(name = "mail_num")
	private String mailNum;
	/**
	* 女性人数
	*/
	@Column(name = "femail_num")
	private String femailNum;
	/**
	* 60岁以下人数
	*/
	@Column(name = "age_range_num1")
	private String ageRangeNum1;
	/**
	* 61-65岁人数
	*/
	@Column(name = "age_range_num2")
	private String ageRangeNum2;
	/**
	* 66-70岁人数
	*/
	@Column(name = "age_range_num3")
	private String ageRangeNum3;
	/**
	* 71-75岁人数
	*/
	@Column(name = "age_range_num4")
	private String ageRangeNum4;
	/**
	* 76-80岁人数
	*/
	@Column(name = "age_range_num5")
	private String ageRangeNum5;
	/**
	* 80岁以上人数
	*/
	@Column(name = "age_range_num6")
	private String ageRangeNum6;
	/**
	* 数据更新时间
	*/
	@Column(name = "update_time")
	private Date updateTime;
	/**
	* 业务库数据产生时间
	*/
	@Column(name = "Biz_time")
	private Date bizTime;
	/**
	* 数据仓数据记录时间
	*/
	@Column(name = "load_time")
	private Date loadTime;
	/**
	* op
	*/
	@Column(name = "op")
	private String op;
	/**
	* tongTime
	*/
	@Column(name = "tong_time")
	private Date tongTime;
	/**
	* tongId
	*/
	@Id
	@Column(name = "tongID")
	private Long tongId;

}
