package com.tykj.transfer.slave_service.impl;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tykj.transfer.dao.ActivitiesDao;
import com.tykj.transfer.dao.ActivityApplyDao;
import com.tykj.transfer.dao.BranchesDao;
import com.tykj.transfer.entity.Activity;
import com.tykj.transfer.entity.Branches;
import com.tykj.transfer.entity.vo.BranchesVo;
import com.tykj.transfer.entity.vo.PageVo;
import com.tykj.transfer.excel.BranchTrainStatExcelVO;
import com.tykj.transfer.local_dao.YlBranchTrainStatisticsDao;
import com.tykj.transfer.local_entity.YlBranchTrainStatistics;
import com.tykj.transfer.pojo.Biz088DcBranchTrainStatistics;
import com.tykj.transfer.slave_dao.Biz088DcBranchTrainStatisticsDao;
import com.tykj.transfer.slave_service.Biz088DcBranchTrainStatisticsService;
import com.tykj.transfer.util.EntityToVoUtil;
import com.tykj.transfer.util.NotNullUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.transaction.Transactional;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@Service
@Slf4j
public class Biz088DcBranchTrainStatisticsImpl implements Biz088DcBranchTrainStatisticsService {

    @Resource
    private StringRedisTemplate stringRedisTemplate;

    @Resource
    private BranchesDao branchesDao;

    @Resource
    private ActivitiesDao activitiesDao;

    @Resource
    private ActivityApplyDao activityApplyDao;

    @Resource
    private Biz088DcBranchTrainStatisticsDao biz088DcBranchTrainStatisticsDao;

    @Resource
    private YlBranchTrainStatisticsDao ylBranchTrainStatisticsDao;

    @Override
//    @Transactional
    public void transferBranchApply() {
        String s = stringRedisTemplate.opsForValue().get("330000YlTotal");
        PageVo pageVo = JSON.parseObject(String.valueOf(s), PageVo.class);
        List<BranchesVo> branchesList = pageVo.getBranchesList();
        List<Biz088DcBranchTrainStatistics> rs = new ArrayList<>();
        List<YlBranchTrainStatistics> listVo = new ArrayList<>();
        Date date = new Date();
        for (BranchesVo branchesVo : branchesList) {
            Biz088DcBranchTrainStatistics VO = new Biz088DcBranchTrainStatistics();
            YlBranchTrainStatistics ylBranchTrainStatistics = new YlBranchTrainStatistics();
            VO.setBranchName(branchesVo.getName());
            Branches allByName = branchesDao.findAllByName(branchesVo.getName()).get(0);
            VO.setId(allByName.getId() + "");
            VO.setRegionCode(allByName.getArea());
            List<Activity> allByBranchId = activitiesDao.findAllByBranchId(allByName.getId());
            Long activityApplyCount = 0L;
            for (Activity activity : allByBranchId) {
                activityApplyCount += activityApplyDao.getActivityApplyCount(activity.getId());
            }
            VO.setTrainNum(String.valueOf(activityApplyCount));
            VO.setUpdateTime(date);
            VO.setBizTime(date);
            VO.setLoadTime(date);
            VO.setTongTime(date);
            VO.setTongId(0L);
            BeanUtils.copyProperties(VO, ylBranchTrainStatistics);
            listVo.add(ylBranchTrainStatistics);
            rs.add(VO);
        }
        biz088DcBranchTrainStatisticsDao.saveAll(rs);
        ylBranchTrainStatisticsDao.saveAll(listVo);
        log.info("网点培训人数转移完成,成功转移了{}条", rs.size());
    }

    @Override
    @Transactional(rollbackOn = Exception.class)
    public void fromExcel(String filePath) {
        JSONObject jsonObject = new JSONObject();
        //根据文件路径获取文件夹下面的所有的文件
        File file = new File(filePath);
        File[] files = file.listFiles();
        //输出文件数量
        log.info("文件数量:{}", files.length);
        File newFile ;
        //最后统一输出到文件中
        try {
            newFile = new File(System.getProperty("user.dir")+ File.separator+"error.txt");
            if (!newFile.exists()){
                newFile.createNewFile();
            }
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        //
        Date date = new Date();
        for (File file1 : files) {
            boolean b = file1.getName().startsWith(".");
            if (!b) {
                ImportParams importParams = new ImportParams();
                importParams.setTitleRows(0);
                importParams.setHeadRows(1);
                List<BranchTrainStatExcelVO> importedExcel = ExcelImportUtil.importExcel(file1, BranchTrainStatExcelVO.class, importParams);
                //过滤出只需要名称包含手机号码的
                List<BranchTrainStatExcelVO> voList = importedExcel.stream()
                        .filter(vo -> {
                            String branchName = vo.getBranchName();
                            String s = removePhoneNumbers(branchName);
                            if (!branchName.equals(s)) {
                                //处理名称
                                vo.setBranchName(s);
                                //处理时间
                                vo.setBizTime(date);
                                vo.setLoadTime(date);
                                vo.setTongTime(date);
                                vo.setTongId(0L);
                                return true;
                            } else {
                                return false;
                            }
                        }).collect(Collectors.toList());
                if (NotNullUtil.collectionNotNull(voList)) {
                    List<YlBranchTrainStatistics> ylBranchTrainStatistics = EntityToVoUtil.listVoStream(voList, YlBranchTrainStatistics.class);
                    ylBranchTrainStatistics.forEach(ylBranchTrainStatistics1 -> {
                        jsonObject.put(ylBranchTrainStatistics1.getId(),file1.getName());
                    });
                    ylBranchTrainStatisticsDao.saveAll(ylBranchTrainStatistics);
                    log.info("文件名:{},成功转移了{}条", file1.getName(), voList.size());
                } else {
                    log.info("文件名:{},没有需要转移的数据", file1.getName());
                }

            }
        }
        //将jsonobj输出到文件中
        try {
            FileUtils.writeStringToFile(newFile, jsonObject.toJSONString(), "UTF-8");
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        String input = "这是一段包含手机号码13512345678的文本，还有另一个号码13998765432。";

        // 判断字符串中是否包含手机号，并替换成空字符串
        String result = removePhoneNumbers(input);

        System.out.println("原始字符串: " + input);
        System.out.println("处理后字符串: " + result);
    }

    public static String removePhoneNumbers(String input) {
        // 匹配手机号的正则表达式
        String regex = "(?<!\\d)(?:(?:1[3456789]\\d{9})|(?:861[3456789]\\d{9}))(?!\\d)";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(input);

        // 替换手机号为""
        String result = matcher.replaceAll("");

        return result;
    }
}
