package com.tykj.transfer.slave_service.impl;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.tykj.transfer.local_dao.YlNetworkStatisticsDao;
import com.tykj.transfer.local_entity.YlNetworkStatistics;
import com.tykj.transfer.slave_dao.Biz088DcNetworkStatisticsDao;
import com.tykj.transfer.slave_service.Biz088DcNetworkStatisticsService;
import com.tykj.transfer.dao.BranchesDao;
import com.tykj.transfer.entity.Branches;
import com.tykj.transfer.pojo.Biz088DcNetworkStatistics;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.transaction.Transactional;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import static com.tykj.transfer.slave_service.impl.Biz088DcActivityStatisticsServiceImpl.filterEmojis;

@Service
@Slf4j
public class Biz088DcNetworkStatisticsImpl implements Biz088DcNetworkStatisticsService {

    @Resource
    private BranchesDao branchesDao;

    @Resource
    private Biz088DcNetworkStatisticsDao biz088DcNetworkStatisticsDao;

    @Resource
    private YlNetworkStatisticsDao ylNetworkStatisticsDao;

    @Override
//    @Transactional
    public void transferBranch() {
        List<Branches> all = branchesDao.findAll();
        int total = all.size();
        int i = 0;
        Date date = new Date();
        for (Branches branches : all) {
            Biz088DcNetworkStatistics newObj = JSON.parseObject(JSON.toJSONString(branches), Biz088DcNetworkStatistics.class);
            newObj.setBizTime(date);
            newObj.setLoadTime(date);
            if (!StringUtils.equals(branches.getDataActiveStatus(), "1")) {
                newObj.setOp("delete");
            }
            newObj.setTongTime(date);
            try {
                newObj.setAddress(filterEmojis(newObj.getAddress()));
            } catch (Exception e) {
                log.error("{}", e);
                e.printStackTrace();
            }

            newObj.setTongId(0L);
            try {
                YlNetworkStatistics ylNetworkStatistics = new YlNetworkStatistics();
                BeanUtils.copyProperties(newObj, ylNetworkStatistics);

                newObj.setName(replacePhone(newObj.getName()));
                newObj.setContactPerson(replacePhone(newObj.getContactPerson()));
                newObj.setLeaderName(replacePhone(newObj.getLeaderName()));

                biz088DcNetworkStatisticsDao.save(newObj);
                ylNetworkStatisticsDao.save(ylNetworkStatistics);
            } catch (Exception e) {
                log.error("{}", e.toString());
                log.error("jpa不成功+1");
            }

            //计数
            i++;
            if (i % 100 == 0) {
                log.info("{}/{}", i / total);
            }

        }
        log.info("网点转移完成");
    }

    public static boolean isNumericZidai(String str) {
        for (int i = 0; i < str.length(); i++) {
            System.out.println(str.charAt(i));
            if (!Character.isDigit(str.charAt(i))) {
                return false;
            }
        }
        return true;
    }

    public static String replacePhone(String s) {
        if (s == null) {
            return "";
        }
        String continuousDigits = findContinuousDigits(s, 11);
        if ( continuousDigits!= null) {
            String replace = s.replace(continuousDigits, "");
            log.info("替换情况:{} -> {}", s, replace);
            return replace;
        } else {
            return s;
        }
    }

    public static String findContinuousDigits(String input, int length) {
        // 构建正则表达式，匹配连续的指定长度的数字
        String regex = "\\d{" + length + "}";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(input);

        if (matcher.find()) {
            return matcher.group();
        } else {
            return null;
        }
    }

    public static void main(String[] args) {
        String str = "花园里15068682696";
        System.out.println(findContinuousDigits(str, 11));
        System.out.println(str.replaceAll(findContinuousDigits(str, 11), ""));
    }
}
