package com.tykj.transfer.task;

import com.tykj.transfer.slave_service.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class PushTask {

    @Autowired
    private Biz088DcActivityStatisticsService biz088DcActivityStatisticsService;
    @Autowired
    private Biz088DcNetworkStatisticsService biz088DcNetworkStatisticsService;
    @Autowired
    private Biz088DcBranchTrainStatisticsService biz088DcBranchTrainStatisticsService;
    @Autowired
    private Biz088DcVolunteerStatisticsService biz088DcVolunteerStatisticsService;
    @Autowired
    private Biz088DcTrainStatisticsService biz088DcTrainStatisticsService;
    @Scheduled(cron = "0 0 1 ? * MON")
    public void task() {
        log.info("周任务开始执行");
        biz088DcActivityStatisticsService.transferActivity();
        biz088DcNetworkStatisticsService.transferBranch();
        biz088DcBranchTrainStatisticsService.transferBranchApply();
        biz088DcVolunteerStatisticsService.transferVolunteer();
        biz088DcTrainStatisticsService.transferTrain();
        log.info("周任务执行完成");
    }
}
