package com.tykj.transfer.util;

import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author: zsp
 * @create: 2023-02-09 22:28
 **/
public class EntityToVoUtil {

    /**
     *
     * @param currentClass 当前对象
     * @param targetClass 目标对象
     * @param <E>
     * @return
     */
    public static <E> E convert(Object currentClass, Class<E> targetClass) {
        // 判断currentClass 是否为空!
        if (currentClass == null) {
            return null;
        }
        // 判断targetClass 是否为空
        if (targetClass == null) {
            return null;
        }
        try {
            // 创建新的对象实例
            E newInstance = targetClass.newInstance();
            // 把原对象数据拷贝到新的对象
            BeanUtils.copyProperties(currentClass, newInstance);
            // 返回新对象
            return newInstance;
        } catch (Exception e) {
            return null;
        }
    }

    /**
     *  Page<Entity> 分页对象转 Page<Vo> （Stream 方式）
     * @param page
     * @param v
     * @param <T>
     * @param <V>
     * @return
     */
    public static  <T, V> Page<V> pageVoStream(Page<T> page, Class<V> v) {
        List<V> voList = page.getContent().stream().map(item -> {
            try {
                return (V) EntityToVoUtil.convert(item, v.newInstance().getClass());
            } catch (InstantiationException | IllegalAccessException e) {
                e.printStackTrace();
            }
            return null;
        }).collect(Collectors.toList());
        return new PageImpl<>(voList, page.getPageable(), page.getTotalElements());
    }

    /**
     * list<Entity> 集合对象转list<Vo> （Stream 方式）
     * @param oldList
     * @param v
     * @param <T>
     * @param <V>
     * @return
     */
    public static <T, V> List<V> listVoStream(List<T> oldList, Class<V> v) {
        List<V> voList = oldList.stream().map(item -> {
            try {
                return (V) EntityToVoUtil.convert(item, v.newInstance().getClass());
            } catch (InstantiationException | IllegalAccessException e) {
                e.printStackTrace();
            }
            return null;
        }).collect(Collectors.toList());
        return voList;
    }

}
