package com.tykj.index.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.tykj.base.entity.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

@AllArgsConstructor
@NoArgsConstructor
@Data
@Entity
@Table
public class IndexInfo extends BaseEntity {

    private String label;

    private String alias;

    private String description;

    private String sqlContent;

    private Integer level;

    private Double weight;

    @Column(columnDefinition = "text")
    private String ranks;

    private Integer parentId;

    @JsonIgnore
    private Integer tableId;

}
