package com.tykj.index.entity.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@AllArgsConstructor
@NoArgsConstructor
@Data
public class IndexInfoVo {

    @ApiModelProperty("主键")
    private Integer id;

    @ApiModelProperty("名称")
    private String label;

    @ApiModelProperty("别名 用于创建对应实体的表名")
    private String alias;

    @ApiModelProperty("简介")
    private String description;

    @ApiModelProperty("SQL内容")
    private String sql;

    @ApiModelProperty("层级")
    private Integer level;

    @ApiModelProperty("权重")
    private Double weight;

    @ApiModelProperty("范围")
    private List<Rank> ranks;

    @ApiModelProperty("下级子节点")
    private List<IndexInfoVo> children;

    @ApiModelProperty("上级节点id")
    private Integer parentId;

}
