package com.tykj.datawarehouse.base.aop;


import com.tykj.datawarehouse.base.entity.BaseEntity;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.springframework.stereotype.Component;

import java.util.Date;

import static java.util.Objects.isNull;

/**
 * @author C
 */
@Aspect
@Component
public class EntityHandle {

    @Before("execution(* org.springframework.data.repository.CrudRepository.save(..)) && args(com.tykj.datawarehouse.base.entity.BaseEntity))")
    public void checkTimes(JoinPoint point) {
        Object[] args = point.getArgs();
        for (Object arg : args) {
            if (arg instanceof BaseEntity){
                BaseEntity entity = (BaseEntity) arg;
                if (isNull(entity.getCreatedTime())){
                    entity.setCreatedTime(new Date());
                }
                entity.setUpdatedTime(new Date());
            }
        }
    }


}
