package com.tykj.model.controller;

import com.tykj.base.result.ResultUtil;
import com.tykj.model.entity.vo.RuleVo;
import com.tykj.model.service.RuleService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

/**
 * @Description TODO
 * @Author WWW
 * @Date 2021/6/29 16:39
 */
@Api(tags = "规则接口")
@RestController
@RequestMapping("/rule")
public class RuleController {

    @Autowired
    RuleService ruleService;

    @ApiOperation("规则删除")
    @GetMapping("/delete")
    public ResponseEntity deleteRule(Integer id) {
        try {
            ruleService.del(id);
            return ResultUtil.success("删除成功！");
        } catch (Exception e) {

        }
        return ResultUtil.failed("此id已经被删除！");
    }

    @ApiOperation("规则新增")
    @PostMapping("/save")
    public ResponseEntity add(@RequestBody RuleVo ruleVo) {
        try {
            ruleService.add(ruleVo);
            return ResultUtil.success("保存成功！");
        } catch (Exception e) {

        }
        return ResultUtil.failed("保存失败！");
    }

    @ApiOperation("规则修改")
    @PostMapping("/update")
    public ResponseEntity update(@RequestBody RuleVo ruleVo) {
        try {
            ruleService.update(ruleVo);
            return ResultUtil.success("操作成功！");
        } catch (Exception ignored) {

        }
        return ResultUtil.failed("操作失败！");
    }

    @ApiOperation("查询全部")
    @PostMapping("/getAll")
    public ResponseEntity get() {

        return ResultUtil.success(ruleService.getAll(), "查询成功");
    }
}
