package com.tykj.datawarehouse.model.entity.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class complexQueryVo
 * @packageName com.tykj.model_layer.entity.vo
 **/
@ApiModel("复杂查询VO")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class complexQueryVo {

    @ApiModelProperty("表名")
    String tableName;

    @ApiModelProperty("筛选字段")
    List<String> columnNames;

    @ApiModelProperty("分类条件信息")
    GroupCondition groupCondition;

    @ApiModelProperty("查询条件")
    List<QueryCondition> queryConditions;

    @ApiModelProperty("分类字段")
    String groupByColumn;

    Integer page = 0 ;

    Integer size = 15 ;
}
