package com.tykj.index.controller;

import com.google.common.collect.ImmutableMap;
import com.tykj.base.result.ResultObj;
import com.tykj.base.result.ResultUtil;
import com.tykj.index.entity.vo.ChartVO;
import com.tykj.index.entity.vo.IndexInfoVo;
import com.tykj.index.entity.vo.MouthChartVo;
import com.tykj.index.service.IndexInfoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

@Api(tags = "指标相关接口")
@RestController
@RequestMapping("/index")
public class IndexInfoController {

    @Autowired
    private IndexInfoService indexInfoService;

    @ApiOperation("新增单个指标 不需要传children数据")
    @PostMapping
    public ResponseEntity<ResultObj<Object>> save(@RequestBody IndexInfoVo indexInfoVo) {
        indexInfoService.save(indexInfoVo);
        return ResultUtil.success("新增成功");
    }

    @ApiOperation("修改单个指标 不需要传children数据")
    @PutMapping
    public ResponseEntity<ResultObj<Object>> update(@RequestBody IndexInfoVo indexInfoVo) {
        indexInfoService.update(indexInfoVo);
        return ResultUtil.success("修改成功");
    }

    @ApiOperation("根据parentId查询剩余可用权重")
    @GetMapping("/remain/weight/{parentId}")
    public ResponseEntity<Map<String, String>> checkRemainWeight(@PathVariable Integer parentId) {
        Double weight = indexInfoService.checkRemainWeight(parentId);
        return ResponseEntity.ok(ImmutableMap.of("weight", weight.toString()));
    }

    @ApiOperation("根据id查图表")
    @GetMapping("/chart/{id}")
    public ResponseEntity<ChartVO> queryChart(@PathVariable Integer id) {
        ChartVO result = indexInfoService.querySQL(id);
        return ResponseEntity.ok(result);
    }

    @ApiOperation("根据id 开始时间和结束时间 查询期间的多个图表数据")
    @GetMapping("/chart/mouth/{id}/{start}/{end}")
    public ResponseEntity<List<MouthChartVo>> queryChildrenChart(@PathVariable Integer id, @PathVariable String start, @PathVariable String end) {
        List<MouthChartVo> result = indexInfoService.queryMouthCharts(id, start, end);
        return ResponseEntity.ok(result);
    }

    @ApiOperation("根据指标id更新其上级节点的数据")
    @GetMapping("/update/values/{id}")
    public ResponseEntity<ResultObj<Object>> updateValues(@PathVariable Integer id) {
        indexInfoService.updateValue(id);
        return ResultUtil.success("同步成功");
    }

    @ApiOperation("查询指标列表 返回的是由根节点展开的指标数据")
    @GetMapping
    public ResponseEntity<List<IndexInfoVo>> findAll() {
        List<IndexInfoVo> root = indexInfoService.findAll();
        return ResponseEntity.ok(root);
    }

    @ApiOperation("删除单个指标")
    @DeleteMapping("/{id}")
    public ResponseEntity<ResultObj<Object>> deleteById(@PathVariable Integer id) {
        indexInfoService.deleteById(id);
        return ResultUtil.success("删除成功");
    }

}
