package com.tykj.index.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.tykj.base.entity.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

@EqualsAndHashCode(callSuper = true)
@AllArgsConstructor
@NoArgsConstructor
@Data
@Entity
@Table
public class IndexInfo extends BaseEntity {

    private String label;

    private String alias;

    private String description;

    private String sqlContent;

    private Integer level;

    @Column(columnDefinition = "text")
    private String ranks;

    @Column(columnDefinition = "test")
    private String pluses;

    private Integer parentId;

    @JsonIgnore
    private Integer tableId;

}
