package com.tykj.model.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

/**
 * 月份计算工具类
 */
public class MonthUtil {

    public static SimpleDateFormat simpleDateFormatMonth = new SimpleDateFormat("yyyy-MM");

    public static SimpleDateFormat simpleDateFormatDay = new SimpleDateFormat("yyyy-MM-DD");

    /**
     * 计算开始时间到结束时间，中间的所有月份
     * @param start 开始时间  例如：2020-1
     * @param end 结束时间  例如：2020-1
     * @return
     */
    public static List<String> getMonthList(String start, String end){
        List<String> date=new ArrayList<String>();
        try{
            Date d1 = new SimpleDateFormat("yyyy-MM").parse(start);//定义起始日期
            Date d2 = new SimpleDateFormat("yyyy-MM").parse(end);//定义结束日期
            Calendar dd = Calendar.getInstance();//定义日期实例
            dd.setTime(d1);//设置日期起始时间
            while (dd.getTime().before(d2)) {//判断是否到结束日期
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
                String str = sdf.format(dd.getTime());
                date.add(str);
                dd.add(Calendar.MONTH, 1);//进行当前日期月份加1
            }
            date.add(end);;//输出日期结果
        }catch (Exception e){
            System.out.println("异常"+e.getMessage());
        }
        return date;
    }

    public static List<String> getMountListEndNow(String start){
        return getMonthList(start,new SimpleDateFormat("yyyy-MM").format(new Date()));
    }

    public static Date lastDay(String month){
        Date parse = null;
        try {
            parse = simpleDateFormatMonth.parse(month);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar ca = Calendar.getInstance();
        ca.setTime(parse);
        ca.set(Calendar.DAY_OF_MONTH, ca.getActualMaximum(Calendar.DAY_OF_MONTH));
        ca.set(Calendar.HOUR_OF_DAY,23);
        ca.set(Calendar.MINUTE,59);
        ca.set(Calendar.SECOND,59);
        return ca.getTime();
    }

    public static Date firstDay(String month){
        Date parse = null;
        try {
            parse = simpleDateFormatMonth.parse(month);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar ca = Calendar.getInstance();
        ca.setTime(parse);
        ca.set(Calendar.DAY_OF_MONTH,1);
        return ca.getTime();
    }


}
