module.exports = {
  root: true,
  env: {
    node: true
  },
  'extends': [
    'plugin:vue/essential',
    'eslint:recommended'
  ],
  parserOptions: {
    ecmaVersion: 2020
  },
  rules: {
      'no-console': process.env.NODE_ENV === 'production' ? 'error' : 'off',
      'no-debugger': process.env.NODE_ENV === 'production' ? 'error' : 'off',
      'no-catch-shadow': 2,//禁止catch子句参数与外部作用域变量同名
      'no-class-assign': 2,//禁止给类赋值
      'camelcase': 2,//强制驼峰法命名
      'vars-on-top': 2,//var必须放在作用域顶部
      'no-redeclare': 2,//禁止重复声明变量
      'complexity': [0, 11]//循环复杂度
  }
}
