import axios from 'axios';
// import Qs from 'qs';
import baseUrl from '../../config';
// import store from '../store';
// axios.defaults.withCredentials = true;
// 添加请求拦截器
axios.interceptors.request.use(function (config) {
    // console.log(store.getters.getSession.session)
    // config.headers.session = store.getters.getSession.session;
    // 预处理请求信息（config 发出的数据） 下方是三种请求，李迪凡的
    if (config.method === 'post' || config.method === 'put' || config.method === 'delete') {
    // POST传参序列化
    }
    return config;
}, function (error) {
    // 预处理请求错误（error）
    return Promise.reject(error);
});

// 添加响应拦截器
axios.interceptors.response.use(function (response) {
    return response;
}, function (error) {
    // 预处理响应错误（error)
    // alert(error);
    return Promise.reject(error);
});

/**
 * 返回axios方法
 * @param url（如果传绝对地址则baseURL不会追加到url之前）
 * @param method
 * @param timeout
 * @param data
 * @param headers
 * @param dataType
 * @returns {AxiosPromise}
 */
export default function(url, {
    // 不传时，默认参数
    method = 'get',
    timeout = 60000,
    data = {},
    headers = {'Content-Type': 'application/json'},  // application/x-www-form-urlencoded;charset=UTF-8;
    dataType = 'json'
}) {
    const config = {
        method: method,
        timeout: timeout,
        url: url, // 如果URL是完整的，包含域名，则下方的域名不会被拼接
        baseURL: baseUrl.URL_CNODEJS, // 域名，在最外层的config.js当中可以修改，请求目标服务器域名配置，结合我们自己的项目，在项目放置到服务器上时，就是将域名替换成192.168.1.3
        data: data,
        headers: headers,
        dataType: dataType
    };
    return axios(config);
}
