import axios from '@/services/axios';

/**
 * 统一处理所有接口请求
 * 参数对象将会替换axios中默认参数中的键值对，其中可包含：
 * method
 * timeout
 * data
 * headers
 * dataType
 */
// import qs from 'qs';
const server = {
    getCeShi() { // 测试接口
        return axios('/resume', {
            method: 'get'
        });
    },
    postadd(data) { // 新增角色
        return axios('/role/add', {
            method: 'post',
            data: data
        });
    },
}
export default server;
