import Vue from 'vue';
import ElementUI from 'element-ui';
import 'element-ui/lib/theme-chalk/index.css';
import App from './App.vue';
import router from './router';
import store from './store';
import server from './services/server';
import './assets/css/base.css';
import echarts from 'echarts'

Vue.prototype.$echarts = echarts

Vue.prototype.$server = server;
Vue.use(ElementUI);
Vue.config.productionTip = false

new Vue({
  router,
  store,
  render: function (h) { return h(App) }
}).$mount('#app')
