import axios from '@/services/axios';

/**
 * 统一处理所有接口请求
 * 参数对象将会替换axios中默认参数中的键值对，其中可包含：
 * method
 * timeout
 * data
 * headers
 * dataType
 */
// import qs from 'qs';
const server = {
    getProject(id) { // 获取项目详情
        return axios('/project/get/' + id, {
            method: 'get'
        })
    },
    findAll() { // 技术路线
        return axios('/tech/findAll/',  {
            method: 'get'
        })
    },
    postMidify(data) { // 项目修改
        return axios('/project/modify',  {
            method: 'post',
            data: data
        })
    },
    setPath(data) { // 修改路径
        return axios('/project/setPath',  {
            method: 'post',
            data: data
        })
    },
    getDeploy(id) { // 获取项目详情
        return axios('/project/deploy/' + id, {
            method: 'get'
        })
    },
    postModify(data) { // 项目修改
        return axios('/project/modify', {
            method: 'post',
            data: data
        })
    },
    getPerformanceData(id) { // 获取性能表格数据
        return axios('/performance/data/' + id, {
            method: 'get'
        })
    },
}
export default server;
