import axios from '@/services/axios';

/**
 * 统一处理所有接口请求
 * 参数对象将会替换axios中默认参数中的键值对，其中可包含：
 * method
 * timeout
 * data
 * headers
 * dataType
 */
// import qs from 'qs';
const server = {
    getProject(id) { // 获取项目详情
        return axios('/project/get/' + id, {
            method: 'get'
        })
    },
    findAll() { // 技术路线
        return axios('/tech/findAll/',  {
            method: 'get'
        })
    },
    midify() { // 技术路线
        return axios('/project/midify/',  {
            method: 'get'
        })
    },
}
export default server;
