package com.example.demo.mapper;

import com.example.demo.entity.Student;
import org.apache.ibatis.annotations.*;

/**
 * @author Administrator
 * 通过该类调用数据库
 */
@Mapper
public interface StuMapper {
    /**
     * 通过id查找学生信息
     * @param id 学生id
     * @return 返回学生对象
     */
    @Select("select * from student where id = #{id}")
    Student select(@Param("id") Integer id);

    /**
     * 添加学生信息
     * @param s 学生对象
     * @return 返回影响字段条数
     */
    @Insert("insert into student (id,name,age,sex) values(#{id},#{name},#{age},#{sex})")
    Integer add(Student s);

    /**
     * 修改学生信息
     * @param s 学生对象
     * @return 返回影响字段条数
     */
    @Update("update student set name = #{name},age = #{age},sex = #{sex} " +
            "where id=#{id}")
    Integer update(Student s);

    /**
     * 删除学生信息
     * @param id 学生id
     * @return 返回影响字段条数
     */
    @Delete("delete from student where id = #{id}")
    Integer delete(@Param("id") Integer id);
}
