package com.example.demo.Controller;

import com.example.demo.entity.Student;
import com.example.demo.service.StuService;
import com.google.gson.Gson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author Administrator
 * 浏览器通过映射地址找到本类方法
 */
@RestController
@RequestMapping("/students")
public class Controller{
    @Autowired
    StuService stuservice;
    @RequestMapping(value = "/{id}",method = RequestMethod.GET)
    String select(@PathVariable Integer id){
        //通过id查找学生
        Student select = stuservice.select(id);
        if(select == null){
            return "没有该学生!";
        }
        Gson gson = new Gson();
        return gson.toJson(select);
    }
    @RequestMapping(value = "/insertion",method = RequestMethod.POST)
    String add(@RequestBody Student s) {
        try {
        if (s.getName().equals("")){
            return "请输入姓名";
    }
        if (s.getAge().equals("")){
            return "请输入年龄";
        }
        if (s.getSex().equals("")){
            return "请输入性别";
        }
        //添加学生
            Integer add = stuservice.add(s);
            if (add>=1){
                return "添加成功!";
            }else{
                return "添加失败!";
            }
        } catch (Exception r) {
            return "参数错误";
        }
    }
    @RequestMapping(value = "/updation",method = RequestMethod.PUT)
    String update(@RequestBody Student s){
        //修改学生
        Integer update = stuservice.update(s);
        if(update<1){
            return "修改失败!";
        }
        return "修改成功!";
    }
    @RequestMapping(value = "/{id}",method = RequestMethod.DELETE)
    String delect(@PathVariable Integer id){
        //通过id删除学生
        Integer delete = stuservice.delete(id);
        if(delete<1){
            return "删除失败!";
        }
        return "删除成功!";
    }
}
