import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Solution {

    /**
     * 题目：1.两数之和
     * 给定一个整数数组 nums 和一个目标值 target，请你在该数组中找出和为目标值的那两个整数，并返回他们的数组下标。
     *
     * 示例:
     * 输入: nums = [2, 7, 11, 15], target = 9
     * 输出: [0, 1]
     * 解释: 2 与 7 之和等于目标数 9 。因此 index1 = 0, index2 = 1
     *
     * @author xuyang
     **/
    public int[] twoSum(int[] nums, int target) {
        int[] res = new int[2];
        for (int i = 1; i < nums.length; i++) {
            for (int j = 0; j < i; j++) {
                if (nums[i] + nums[j] == target) {
                    res[0] = j;
                    res[1] = i;
                    return res;
                }
            }
        }
        return nums;
    }

    /**
     * 题目：167. 两数之和 II - 输入有序数组
     * 给定一个已按照升序排列 的有序数组，找到两个数使得它们相加之和等于目标数。
     *
     * 示例:
     * 输入: nums = [2, 7, 11, 15], target = 9
     * 输出: [0, 1]
     * 解释: 2 与 7 之和等于目标数 9 。因此 index1 = 0, index2 = 1
     *
     * @author xuyang
     **/
    public int[] twoSumSorted(int[] numbers, int target) {
        int i = 0;
        int j = numbers.length - 1;
        int sum = 0;
        int[] res = new int[2];
        while(i < j) {
            sum = numbers[i] + numbers[j];
            if(sum < target) {
                i++;
            }
            if(sum > target) {
                j--;
            }
            if(sum == target) {
                res[0] = i;
                res[1] = j;
                return res;
            }
        }
        return numbers;
    }

    /**
     * 题目：11. 盛最多水的容器
     *  n 个非负整数 a1，a2，...，an，每个数代表坐标中的一个点 (i, ai) 。在坐标内画 n 条垂直线，垂直线 i 的两个端点分别为 (i, ai) 和
     *  (i, 0)。找出其中的两条线，使得它们与 x 轴共同构成的容器可以容纳最多的水
     *
     * 示例:
     * 输入: [1,8,6,2,5,4,8,3,7]
     * 输出: 49
     * 解释:
     *
     * @author xuyang
     **/
    public int maxArea(int[] height) {
        int sum = 0;
        int len = 0;
        int high = 0;
        int squ = 0;
        for(int i = 0; i < height.length-1; i++){
            for(int j = i+1; j < height.length; j++){
                len = j - i;
                high = (height[i]<height[j]) ? height[i] : height[j];
                squ = len * high;
                if(squ > sum) {
                    sum = squ;
                }
            }
        }
        return sum;
    }

    /**
     * 题目：15. 三数之和
     *  一个包含 n 个整数的数组 nums，判断 nums 中是否存在三个元素 a，b，c ，使得 a + b + c = 0 ？请你找出所有满足条件且不重复的三元组
     *
     * 示例:
     * 输入:  nums = [-1, 0, 1, 2, -1, -4]
     * 输出: [
     *   [-1, 0, 1],
     *   [-1, -1, 2]
     * ]
     * 解释:
     *
     * @author xuyang
     * 双指针
     **/
    public List<List<Integer>> threeSum(int[] nums) {
        Arrays.sort(nums);
        List<List<Integer>> lists = new ArrayList<>();
        for(int i = 0; i < nums.length-2; i++) {
            int a = i+1;
            int b = nums.length-1;
            if(nums[i] > 0) {
                break;
            }
            if(i > 0 && nums[i] == nums[i-1]) {
                continue;
            }
            while (a < b) {
                int sum = nums[i] + nums[a] + nums[b];
                if(sum < 0) {
                    while(nums[a] == nums[a+1] && a < b) {
                        a++;
                    }
                }else if(sum > 0) {
                    while(nums[b] == nums[b-1] && a < b) {
                        b--;
                    }
                }else {
                    List<Integer> list = new ArrayList<>();
                    list.add(nums[i]);
                    list.add(nums[a]);
                    list.add(nums[b]);
                    lists.add(list);
                    while(nums[a] == nums[a+1] && a < b) {
                        a++;
                    }
                    while(nums[b] == nums[b-1] && a < b) {
                        b--;
                    }
                }
            }
        }
        return lists;
    }

    /**
     * 题目：42. 接雨水
     *  给定 n 个非负整数表示每个宽度为 1 的柱子的高度图，计算按此排列的柱子，下雨之后能接多少雨水。
     *
     * 示例:
     * 输入:  [0,1,0,2,1,0,1,3,2,1,2,1]
     * 输出: 6
     * 解释:
     *
     * @author xuyang
     * 根据一个结点，在它左右两端分别找出最长边，取其中的较小值
     **/
    public int trap(int[] height) {
        int sum = 0;
        for (int i = 1; i < height.length - 1; i++) {
            int max_left = 0;
            for (int j = i - 1; j >= 0; j--) {
                if (height[j] > max_left) {
                    max_left = height[j];
                }
            }
            int max_right = 0;
            for (int j = i + 1; j < height.length; j++) {
                if (height[j] > max_right) {
                    max_right = height[j];
                }
            }
            int min = Math.min(max_left, max_right);
            if (min > height[i]) {
                sum = sum + (min - height[i]);
            }
        }
        return sum;
    }
}
