package com.example.dao;

import com.example.entity.Book;
import org.apache.ibatis.annotations.*;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 描述：书籍相关操作服务层
 *
 * @author Yangxue
 * @version V1.0
 * @class DaoMapper
 * @packageName com.example.dao
 * @description 提供书籍的增删改查接口
 * @data 2020/4/13
 **/







@Repository
@Mapper
public interface DaoMapper {

/**
 * 
 * @param book 
 * @Return : int
 * @Author : YangXue
 * @Date : 2020/4/14 10:37
*/
    @Insert("insert into book(name,author,price,num)values(#{name},#{author},#{price},#{num})")
    int insert(Book book);

    @Delete("delete from book where id = #{id}")
    int delete(Integer id);

    @Update("update book set name=#{book.name},author=#{book.author},price=#{book.price},num=#{book.num} where id =#{id}")
    int update(Integer id,Book book);

    @Select("select id,name,author,price,num from book where id=#{id}")
    Book selectById(Integer id);

    @Select("select id,name,author,price,num from book")
    List<Book> selectAll();



}






