package com.example.dao;

import com.example.entity.Record;
import org.apache.ibatis.annotations.*;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
/**
 * 描述：书籍相关操作服务层
 *
 * @author Yangxue
 * @version V1.0
 * @class DaoMapper
 * @packageName com.example.dao
 * @description 提供记录的增删改查接口
 * @data 2020/4/13
 *
 **/

@Repository
@Mapper
public interface RecordMapper {

    @Insert("insert into record(bookId,userId)values(#{bookId},#{userId})")
    int insert(Record record);

    @Delete("delete from record where recordId=#{recordId}")
    int delete(int recordId);

    @Update("update record set returnDate=#{record.returnDate},hasReturn=#{record.hasReturn} where recordId =#{recordId}")
    int update(int recordId,Record record);

    @Select("select * from record where recordId =#{recordId} ")
    Record selectById(int recordId);

    @Select("select * from record")
    List<Record> selectAll();

}
