package com.example.service;

import com.example.dao.DaoMapper;
import com.example.entity.Book;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class BookServiceImpl implements BookService {
    @Autowired
    private DaoMapper daoMapper;

    /**
     *
     * @param book
     * @Return : 成功添加的记录数
     * @Author : YangXue
     * @Date : 2020/4/14 10:41
     * @describe:添加
    */
    @Override
    public int insert(Book book) {
        return daoMapper.insert(book);
    }

    /**
     *
     * @param id
     * @Return : 成功删除的记录数
     * @Author : YangXue
     * @Date : 2020/4/14 10:41
     * @describe:   删除书籍
     */
    @Override
    public int delete(Integer id) {
        return daoMapper.delete(id);
    }

    /**
     *
     * @param id,book
     * @Return : 成功更新的记录数
     * @Author : YangXue
     * @Date : 2020/4/14 10:43
     * @describe:   更新书籍
    */
    @Override
    public int  update(Integer id, Book book) {
        return daoMapper.update(id,book);
    }

    /**
     * @param id
     * @Return : com.example.entity.Book
     * @Author : YangXue
     * @Date : 2020/4/14 10:45
     * @describe:   根据书籍编号查找书籍
    */

    @Override
    public Book selectById(Integer id) {
        return daoMapper.selectById(id);
    }

    /**
     * @Return : java.util.List<com.example.entity.Book>
     * @Author : YangXue
     * @Date : 2020/4/14 10:47
     * * * @describe:   查找全部书籍
    */
    @Override
    public List<Book> selectAll() {
        return daoMapper.selectAll();
    }
}
