package com.example.service;

import com.example.dao.RecordMapper;
import com.example.entity.Book;
import com.example.entity.Record;
import com.example.entity.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.util.Date;
import java.util.List;

@Service
public class RecordServiceImpl implements RecordService {

    @Autowired
    private RecordMapper recordMapper;
    @Autowired
    private BookService bookService;
    @Autowired
    private UserService userService;

    /**
     *
     * @param record
     * @Return : int
     * @Author : YangXue
     * @Date : 2020/4/14 10:49
     * @describe:   借书时生成新订单
    */
    @Override
    public int insert(Record record) {
        Assert.notNull(record.getUserId(),"用户ID不能为空");
        Assert.notNull(record.getBookId(),"书籍ID不能为空");
        User user = userService.selectById(record.getUserId());
        Book book = bookService.selectById(record.getBookId());
        Assert.notNull(user,"用户不存在");
        Assert.notNull(book,"书籍不存在");
        if (book.getNum()<=0){
            throw new IllegalArgumentException("库存不足");
        }
        book.setNum(book.getNum()-1);
        bookService.update(book.getId(),book);
        return recordMapper.insert(record);
    }

    /**
     *
     * @param recordId
     * @Return : com.example.entity.Record
     * @Author : YangXue
     * @Date : 2020/4/14 10:49
     * @describe:   根据订单号还书
    */
    @Override
    public Record returnBook(int recordId) {
        Record record = recordMapper.selectById(recordId);
        if (record.isHasReturn()== false){
        record.setReturnDate(new Date());
        record.setHasReturn(true);
        Book book = bookService.selectById(record.getBookId());
        book.setNum(book.getNum()+1);
        bookService.update(book.getId(),book);
        recordMapper.update(recordId,record);
        }
        return recordMapper.selectById(record.getRecordId());
    }

    /**
     *
     * @param recordId
     * @Return : int
     * @Author : YangXue
     * @Date : 2020/4/14 10:50
     * @describe:   根据记录编号查找借书记录
    */
    @Override
    public int delete(int recordId) {
        return 0;
    }

    /**
     * @param recordId
     * @param record
     * @Return : int
     * @Author : YangXue
     * @Date : 2020/4/14 10:51
     * @describe:   更新记录的信息
    */
    @Override
    public int update(int recordId,Record record) {
        return recordMapper.update(recordId,record);
    }

    /**
     *
     * @param recordId
     * @Return : com.example.entity.Record
     * @Author : YangXue
     * @Date : 2020/4/14 10:52
     * @describe:   根据编号查找记录
    */
    @Override
    public Record selectById(int recordId) {
        return recordMapper.selectById(recordId);
    }
    /**
     *
     * @Return : java.util.List<com.example.entity.Record>
     * @Author : YangXue
     * @Date : 2020/4/14 10:53
     * * @describe:   根据全部记录
    */

    @Override
    public List<Record> selectAll() {
        return recordMapper.selectAll();
    }
}
