package com.example.service;

import com.example.dao.UserMapper;
import com.example.entity.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class UserServiceImpl implements UserService {
    @Autowired
    private UserMapper userMapper;

    /**
     *
     * @param user
     * @Return : int
     * @Author : YangXue
     * @Date : 2020/4/14 10:55
     * @describe:  添加用户
    */
    @Override
    public int insert(User user) {
        return userMapper.insert(user);
    }

    /**
     * @param userId
     * @param user
     * @Return : int
     * @Author : YangXue
     * @Date : 2020/4/14 10:56
     * @describe: 更新用户信息
    */

    @Override
    public int update(int userId,User user) {
        return userMapper.update(userId,user);
    }

    /**
     *
     * @param userId
     * @Return : int
     * @Author : YangXue
     * @Date : 2020/4/14 10:56
     * @describe: 根据用户编号删除用户信息
    */
    @Override
    public int delete(int userId) {
        return userMapper.delete(userId);
    }

    /**
     *
     * @param userId
     * @Return : com.example.entity.User
     * @Author : YangXue
     * @Date : 2020/4/14 10:57
     * @describe: 根据用户编号查找用户
    */
    @Override
    public User selectById(int userId) {
        User user = userMapper.selectById(userId);
        return user;
    }

    /**
     *
     * @Return : java.util.List<com.example.entity.User>
     * @Author : YangXue
     * @Date : 2020/4/14 10:57
     * @describe: 查找全部用户信息
    */
    @Override
    public List<User> selectAll() {
        return userMapper.selectAll();
    }
}
