package com.example.controller;

import com.example.entity.Book;
import com.example.service.BookService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
public class BookController {
    @Autowired
    private BookService bookService;

    @RequestMapping(value = "/insert")
    public String book(){
        Book book = new Book();
        book.setName("西游记");
        book.setAuthor("吴承恩");
        book.setPrice(52.3);
        book.setNum(10);
        int i = bookService.insert(book);
        return "成功加入"+i+"条记录";
    }

    @RequestMapping(value = "/selectAll")
    public String findAll(){
        List<Book> bookList = bookService.selectAll();
        bookList.stream().forEach(System.out::println);
        return bookList.toString();
    }

    @RequestMapping(value = "/selectById")
    public Book selectById(){
        Book book = bookService.selectById(1);
        return book;
    }

    @RequestMapping(value = "/update")
    public String update(){
        Book book = new Book();
        book.setName("红楼梦");
        book.setAuthor("曹雪芹");
        book.setPrice(52.2);
        book.setNum(13);
        int i = bookService.update(2,book);
        return "成功更新"+i+"条记录";

    }

    @RequestMapping(value = "/delete")
    public String delete(){
        int i = bookService.delete(3);
        return "成功删除"+i+"条记录";
    }





}
