//package com.example.config;
//
//import com.mysql.cj.jdbc.AbandonedConnectionCleanupThread;
//import com.zaxxer.hikari.HikariConfig;
//import com.zaxxer.hikari.HikariDataSource;
//import org.apache.commons.logging.Log;
//import org.apache.commons.logging.LogFactory;
//import org.mybatis.spring.SqlSessionFactoryBean;
//import org.mybatis.spring.annotation.MapperScan;
//import org.springframework.beans.factory.annotation.Value;
//import org.springframework.context.annotation.Bean;
//import org.springframework.context.annotation.Configuration;
//import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
//import org.springframework.core.io.support.ResourcePatternResolver;
//import org.springframework.jdbc.datasource.DataSourceTransactionManager;
//import org.springframework.transaction.annotation.EnableTransactionManagement;
//
//import javax.annotation.PreDestroy;
//import javax.sql.DataSource;
//import java.io.IOException;
//
///**
// * 数据持久层配置
// *
// * @author smartye
// */
//@Configuration
//@MapperScan(basePackages = "com.example.dao")
//@EnableTransactionManagement
//public class MybatisConfig {
//
//    Log log = LogFactory.getLog(getClass());
//
//    HikariDataSource ds;
//
//    @Bean
//    public DataSource dataSource(@Value("com.mysql.cj.jdbc.Driver") String driverClassName,
//                                 @Value("jdbc:mysql://localhost:3306/book?useSSL=false&useUnicode=true&characterEncoding=utf-8&autoReconnect=true&serverTimezone=Asia/Shanghai") String jdbcUrl,
//                                 @Value("root") String username,
//                                 @Value("root") String password
//                                ) {
//        HikariConfig config = new HikariConfig();
//        config.setDriverClassName(driverClassName);
//        config.setJdbcUrl(jdbcUrl);
//        config.setUsername(username);
//        config.setPassword(password);
//        config.addDataSourceProperty("cachePrepStmts", true);
//        config.addDataSourceProperty("useServerPrepStmts", true);
//        config.addDataSourceProperty("maintainTimeStats", false);
//        config.setIdleTimeout(60000);
//        config.setConnectionTimeout(60000);
//        config.setValidationTimeout(3000);
//        config.setMaximumPoolSize(20);
//        config.setMaxLifetime(60000);
//        config.setMinimumIdle(10);
//        config.setConnectionTestQuery("select 1");
//        ds = new HikariDataSource(config);
//        return ds;
//    }
//
//    @Bean
//    public SqlSessionFactoryBean sqlSessionFactoryBean(DataSource dataSource) throws IOException {
//        SqlSessionFactoryBean bean = new SqlSessionFactoryBean();
//        bean.setDataSource(dataSource);
//        ResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
//        bean.setMapperLocations(resolver.getResources("classpath*:mapper/*.xml"));
//        return bean;
//    }
//
//    /**
//     * 开启Spring的事务处理
//     */
//    @Bean
//    public DataSourceTransactionManager dataSourceTransactionManager(DataSource dataSource) {
//        DataSourceTransactionManager manager = new DataSourceTransactionManager();
//        manager.setDataSource(dataSource);
//        return manager;
//    }
//
//    @PreDestroy
//    public void destroy() {
//        ds.close();
//        log.debug("关闭数据库连接池");
//        AbandonedConnectionCleanupThread.checkedShutdown();
//    }
//}