package com.example.controller;

import com.example.entity.Book;
import com.example.service.BookService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping(value = "/book")
public class BookController {
    @Autowired
    private BookService bookService;

    @RequestMapping(value = "/insert")
    public  List<Book> book( Book book){
        bookService.insert(book);
        return bookService.selectAll();

    }

    @RequestMapping(value = "/selectAll")
    public List<Book> findAll(){
        List<Book> bookList = bookService.selectAll();
        return bookList;
    }

    @RequestMapping(value = "/selectById")
    public Book selectById(int id){
        Assert.notNull(id,"id不能为空");
        Book book = bookService.selectById(id);
        return book;
    }

    @RequestMapping(value = "/update")
    public List<Book> update( Book book){
        bookService.update(book.getId(),book);
        return bookService.selectAll();
    }

    @RequestMapping(value = "/delete")
    public List<Book> delete(int id){
        bookService.delete(id);
        return bookService.selectAll();
    }

}
